/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.util.v1_0;

import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.type.virtual.constants.VirtualCPTypeConstants;
import com.liferay.commerce.product.type.virtual.model.CPDVirtualSettingFileEntry;
import com.liferay.commerce.product.type.virtual.model.CPDefinitionVirtualSetting;
import com.liferay.commerce.product.type.virtual.service.CPDVirtualSettingFileEntryService;
import com.liferay.commerce.product.type.virtual.service.CPDefinitionVirtualSettingService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuVirtualSettings;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuVirtualSettingsFileEntry;
import com.liferay.headless.commerce.admin.catalog.internal.util.FileEntryUtil;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.upload.UniqueFileNameProvider;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SkuVirtualSettingsUtil {
    public static CPDefinitionVirtualSetting addOrUpdateSkuVirtualSettings(CPInstance cpInstance, SkuVirtualSettings skuVirtualSettings, CPDefinitionVirtualSettingService cpDefinitionVirtualSettingService, CPDVirtualSettingFileEntryService cpdVirtualSettingFileEntryService, DLAppService dlAppService, RepositoryLocalService repositoryLocalService, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        CPDefinitionVirtualSetting cpDefinitionVirtualSetting = cpDefinitionVirtualSettingService.fetchCPDefinitionVirtualSetting(CPInstance.class.getName(), cpInstance.getCPInstanceId());
        if (cpDefinitionVirtualSetting == null) {
            return SkuVirtualSettingsUtil._addSkuVirtualSettings(cpInstance, skuVirtualSettings, cpDefinitionVirtualSettingService, cpdVirtualSettingFileEntryService, dlAppService, repositoryLocalService, uniqueFileNameProvider, serviceContext);
        }
        return SkuVirtualSettingsUtil._updateSkuVirtualSettings(cpInstance, cpDefinitionVirtualSetting, cpdVirtualSettingFileEntryService, skuVirtualSettings, cpDefinitionVirtualSettingService, dlAppService, repositoryLocalService, uniqueFileNameProvider, serviceContext);
    }

    private static CPDefinitionVirtualSetting _addSkuVirtualSettings(CPInstance cpInstance, SkuVirtualSettings skuVirtualSettings, CPDefinitionVirtualSettingService cpDefinitionVirtualSettingService, CPDVirtualSettingFileEntryService cpdVirtualSettingFileEntryService, DLAppService dlAppService, RepositoryLocalService repositoryLocalService, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        if (!GetterUtil.getBoolean((Object)skuVirtualSettings.getOverride())) {
            return null;
        }
        String attachmentURL = SkuVirtualSettingsUtil._validateURL(skuVirtualSettings.getUrl());
        long attachmentFileEntryId = FileEntryUtil.getFileEntryId(skuVirtualSettings.getAttachment(), attachmentURL, cpInstance.getGroupId(), cpdVirtualSettingFileEntryService, dlAppService, repositoryLocalService, uniqueFileNameProvider, serviceContext);
        String sampleAttachmentURL = null;
        long sampleFileEntryId = 0L;
        boolean useSample = GetterUtil.getBoolean((Object)skuVirtualSettings.getUseSample());
        if (useSample) {
            sampleAttachmentURL = SkuVirtualSettingsUtil._validateURL(skuVirtualSettings.getSampleURL());
            sampleFileEntryId = FileEntryUtil.getFileEntryId(skuVirtualSettings.getSampleAttachment(), sampleAttachmentURL, cpInstance.getGroupId(), cpdVirtualSettingFileEntryService, dlAppService, repositoryLocalService, uniqueFileNameProvider, serviceContext);
        }
        Map termsOfUseContentMap = null;
        long termsOfUseJournalArticleId = 0L;
        boolean termsOfUseRequired = GetterUtil.getBoolean((Object)skuVirtualSettings.getTermsOfUseRequired());
        if (termsOfUseRequired) {
            termsOfUseContentMap = LanguageUtils.getLocalizedMap((Map)skuVirtualSettings.getTermsOfUseContent());
            termsOfUseJournalArticleId = GetterUtil.getLong((Object)skuVirtualSettings.getTermsOfUseJournalArticleId());
        }
        CPDefinitionVirtualSetting cpDefinitionVirtualSetting = cpDefinitionVirtualSettingService.addCPDefinitionVirtualSetting(CPInstance.class.getName(), cpInstance.getCPInstanceId(), attachmentFileEntryId, attachmentURL, SkuVirtualSettingsUtil._getActivationStatus(GetterUtil.getInteger((Object)skuVirtualSettings.getActivationStatus(), (int)0)), TimeUnit.DAYS.toMillis(GetterUtil.getLong((Object)skuVirtualSettings.getDuration())), GetterUtil.getInteger((Object)skuVirtualSettings.getMaxUsages()), useSample, sampleFileEntryId, sampleAttachmentURL, termsOfUseRequired, termsOfUseContentMap, termsOfUseJournalArticleId, true, serviceContext);
        if (skuVirtualSettings.getSkuVirtualSettingsFileEntries() == null) {
            return cpDefinitionVirtualSetting;
        }
        for (SkuVirtualSettingsFileEntry productVirtualSettingsFileEntry : skuVirtualSettings.getSkuVirtualSettingsFileEntries()) {
            cpdVirtualSettingFileEntryService.addCPDefinitionVirtualSetting(cpDefinitionVirtualSetting.getGroupId(), CPInstance.class.getName(), cpInstance.getCPInstanceId(), cpDefinitionVirtualSetting.getCPDefinitionVirtualSettingId(), FileEntryUtil.getFileEntryId(productVirtualSettingsFileEntry.getAttachment(), productVirtualSettingsFileEntry.getUrl(), cpInstance.getGroupId(), cpdVirtualSettingFileEntryService, dlAppService, repositoryLocalService, uniqueFileNameProvider, serviceContext), productVirtualSettingsFileEntry.getUrl(), productVirtualSettingsFileEntry.getVersion());
        }
        return cpDefinitionVirtualSetting;
    }

    private static int _getActivationStatus(int activationStatus) {
        if (ArrayUtil.contains((int[])VirtualCPTypeConstants.ACTIVATION_STATUSES, (int)activationStatus)) {
            return activationStatus;
        }
        return 0;
    }

    private static CPDefinitionVirtualSetting _updateSkuVirtualSettings(CPInstance cpInstance, CPDefinitionVirtualSetting cpDefinitionVirtualSetting, CPDVirtualSettingFileEntryService cpdVirtualSettingFileEntryService, SkuVirtualSettings skuVirtualSettings, CPDefinitionVirtualSettingService cpDefinitionVirtualSettingService, DLAppService dlAppService, RepositoryLocalService repositoryLocalService, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        Long duration;
        if (!GetterUtil.getBoolean((Object)skuVirtualSettings.getOverride(), (boolean)cpDefinitionVirtualSetting.isOverride())) {
            return cpDefinitionVirtualSettingService.deleteCPDefinitionVirtualSetting(CPInstance.class.getName(), cpInstance.getCPInstanceId());
        }
        long attachmentFileEntryId = 0L;
        String attachmentURL = SkuVirtualSettingsUtil._validateURL(skuVirtualSettings.getUrl());
        if (Validator.isNull((String)attachmentURL)) {
            List cpdVirtualSettingFileEntries = cpDefinitionVirtualSetting.getCPDVirtualSettingFileEntries();
            CPDVirtualSettingFileEntry cpdVirtualSettingFileEntry = (CPDVirtualSettingFileEntry)cpdVirtualSettingFileEntries.get(0);
            if (Validator.isNull((String)skuVirtualSettings.getAttachment())) {
                attachmentURL = cpdVirtualSettingFileEntry.getUrl();
            } else {
                attachmentFileEntryId = FileEntryUtil.getFileEntryId(skuVirtualSettings.getAttachment(), attachmentURL, cpInstance.getGroupId(), cpdVirtualSettingFileEntryService, dlAppService, repositoryLocalService, uniqueFileNameProvider, serviceContext);
            }
            if (attachmentFileEntryId == 0L) {
                attachmentFileEntryId = cpdVirtualSettingFileEntry.getFileEntryId();
            }
        }
        if ((duration = skuVirtualSettings.getDuration()) != null) {
            duration = TimeUnit.DAYS.toMillis(duration);
        }
        String sampleAttachmentURL = null;
        long sampleFileEntryId = 0L;
        boolean useSample = GetterUtil.getBoolean((Object)skuVirtualSettings.getUseSample(), (boolean)cpDefinitionVirtualSetting.isUseSample());
        if (useSample && Validator.isNull((String)(sampleAttachmentURL = SkuVirtualSettingsUtil._validateURL(skuVirtualSettings.getSampleURL())))) {
            if (Validator.isNull((String)skuVirtualSettings.getSampleAttachment())) {
                sampleAttachmentURL = cpDefinitionVirtualSetting.getSampleURL();
            } else {
                sampleFileEntryId = FileEntryUtil.getFileEntryId(skuVirtualSettings.getSampleAttachment(), sampleAttachmentURL, cpInstance.getGroupId(), cpdVirtualSettingFileEntryService, dlAppService, repositoryLocalService, uniqueFileNameProvider, serviceContext);
            }
            if (sampleFileEntryId == 0L) {
                sampleFileEntryId = cpDefinitionVirtualSetting.getSampleFileEntryId();
            }
        }
        Map termsOfUseContentMap = null;
        long termsOfUseJournalArticleId = 0L;
        boolean termsOfUseRequired = GetterUtil.get((Object)skuVirtualSettings.getTermsOfUseRequired(), (boolean)cpDefinitionVirtualSetting.isTermsOfUseRequired());
        if (termsOfUseRequired) {
            termsOfUseContentMap = LanguageUtils.getLocalizedMap((Map)skuVirtualSettings.getTermsOfUseContent());
            termsOfUseJournalArticleId = GetterUtil.getLong((Object)skuVirtualSettings.getTermsOfUseJournalArticleId());
            if (termsOfUseContentMap == null && termsOfUseJournalArticleId == 0L) {
                JournalArticle termsOfUseJournalArticle = cpDefinitionVirtualSetting.getTermsOfUseJournalArticle();
                if (termsOfUseJournalArticle != null) {
                    termsOfUseJournalArticleId = termsOfUseJournalArticle.getResourcePrimKey();
                } else {
                    termsOfUseContentMap = cpDefinitionVirtualSetting.getTermsOfUseContentMap();
                }
            }
        }
        cpDefinitionVirtualSetting = cpDefinitionVirtualSettingService.updateCPDefinitionVirtualSetting(cpDefinitionVirtualSetting.getCPDefinitionVirtualSettingId(), attachmentFileEntryId, attachmentURL, SkuVirtualSettingsUtil._getActivationStatus(GetterUtil.getInteger((Object)skuVirtualSettings.getActivationStatus(), (int)cpDefinitionVirtualSetting.getActivationStatus())), GetterUtil.getLong((Object)duration, (long)cpDefinitionVirtualSetting.getDuration()), GetterUtil.getInteger((Object)skuVirtualSettings.getMaxUsages(), (int)cpDefinitionVirtualSetting.getMaxUsages()), useSample, sampleFileEntryId, sampleAttachmentURL, termsOfUseRequired, termsOfUseContentMap, termsOfUseJournalArticleId, true, serviceContext);
        if (skuVirtualSettings.getSkuVirtualSettingsFileEntries() == null) {
            return cpDefinitionVirtualSetting;
        }
        for (CPDVirtualSettingFileEntry cpdVirtualSettingFileEntry : cpDefinitionVirtualSetting.getCPDVirtualSettingFileEntries()) {
            cpdVirtualSettingFileEntryService.deleteCPDVirtualSettingFileEntry(CPInstance.class.getName(), cpDefinitionVirtualSetting.getClassPK(), cpdVirtualSettingFileEntry.getCPDefinitionVirtualSettingFileEntryId());
        }
        for (SkuVirtualSettingsFileEntry skuVirtualSettingsFileEntry : skuVirtualSettings.getSkuVirtualSettingsFileEntries()) {
            cpdVirtualSettingFileEntryService.addCPDefinitionVirtualSetting(cpDefinitionVirtualSetting.getGroupId(), CPInstance.class.getName(), cpDefinitionVirtualSetting.getClassPK(), cpDefinitionVirtualSetting.getCPDefinitionVirtualSettingId(), FileEntryUtil.getFileEntryId(skuVirtualSettingsFileEntry.getAttachment(), skuVirtualSettingsFileEntry.getUrl(), cpInstance.getGroupId(), cpdVirtualSettingFileEntryService, dlAppService, repositoryLocalService, uniqueFileNameProvider, serviceContext), skuVirtualSettingsFileEntry.getUrl(), skuVirtualSettingsFileEntry.getVersion());
        }
        return cpDefinitionVirtualSetting;
    }

    private static String _validateURL(String value) throws Exception {
        if (Validator.isNotNull((String)value)) {
            URL url = new URL(value);
            return url.toString();
        }
        return null;
    }
}

