/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuSubscriptionConfiguration;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.model.CPInstance"}, service={DTOConverter.class})
public class SkuSubscriptionConfigurationDTOConverter
implements DTOConverter<CPInstance, SkuSubscriptionConfiguration> {
    @Reference
    private CPInstanceService _cpInstanceService;

    public String getContentType() {
        return SkuSubscriptionConfiguration.class.getSimpleName();
    }

    public SkuSubscriptionConfiguration toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CPInstance cpInstance = this._cpInstanceService.getCPInstance(((Long)dtoConverterContext.getId()).longValue());
        return new SkuSubscriptionConfiguration(){
            {
                this.setDeliverySubscriptionEnable(() -> ((CPInstance)cpInstance).isDeliverySubscriptionEnabled());
                this.setDeliverySubscriptionLength(() -> ((CPInstance)cpInstance).getDeliverySubscriptionLength());
                this.setDeliverySubscriptionNumberOfLength(() -> ((CPInstance)cpInstance).getDeliveryMaxSubscriptionCycles());
                this.setDeliverySubscriptionType(() -> SkuSubscriptionConfiguration.DeliverySubscriptionType.create((String)cpInstance.getDeliverySubscriptionType()));
                this.setDeliverySubscriptionTypeSettings(() -> ((CPInstance)cpInstance).getDeliverySubscriptionTypeSettingsUnicodeProperties());
                this.setEnable(() -> ((CPInstance)cpInstance).isSubscriptionEnabled());
                this.setLength(() -> ((CPInstance)cpInstance).getSubscriptionLength());
                this.setNumberOfLength(() -> ((CPInstance)cpInstance).getMaxSubscriptionCycles());
                this.setOverrideSubscriptionInfo(() -> ((CPInstance)cpInstance).isOverrideSubscriptionInfo());
                this.setSubscriptionType(() -> SkuSubscriptionConfiguration.SubscriptionType.create((String)cpInstance.getSubscriptionType()));
                this.setSubscriptionTypeSettings(() -> ((CPInstance)cpInstance).getSubscriptionTypeSettingsUnicodeProperties());
            }
        };
    }
}

