/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPInstanceOptionValueRel;
import com.liferay.commerce.product.model.CPInstanceUnitOfMeasure;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalService;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelLocalService;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.product.util.CPInstanceHelper;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuOption;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuUnitOfMeasure;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.model.CPInstance"}, service={DTOConverter.class})
public class SkuDTOConverter
implements DTOConverter<CPInstance, Sku> {
    @Reference
    private CPDefinitionOptionRelLocalService _cpDefinitionOptionRelLocalService;
    @Reference
    private CPDefinitionOptionValueRelLocalService _cpDefinitionOptionValueRelLocalService;
    @Reference
    private CPInstanceHelper _cpInstanceHelper;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.SkuUnitOfMeasureDTOConverter)")
    private DTOConverter<CPInstanceUnitOfMeasure, SkuUnitOfMeasure> _skuUnitOfMeasureDTOConverter;

    public String getContentType() {
        return Sku.class.getSimpleName();
    }

    public Sku toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPInstance cpInstance = this._cpInstanceService.getCPInstance(((Long)dtoConverterContext.getId()).longValue());
        final CPDefinition cpDefinition = cpInstance.getCPDefinition();
        final CPInstance replacementCPInstance = this._cpInstanceService.fetchCProductInstance(cpInstance.getReplacementCProductId(), cpInstance.getReplacementCPInstanceUuid());
        final CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure = (CPInstanceUnitOfMeasure)dtoConverterContext.getAttribute("cpInstanceUnitOfMeasure");
        return new Sku(){
            {
                this.setCost(() -> ((CPInstance)cpInstance).getCost());
                this.setCustomFields(() -> CustomFieldsUtil.toCustomFields(dtoConverterContext.isAcceptAllLanguages(), CPInstance.class.getName(), cpInstance.getCPInstanceId(), cpInstance.getCompanyId(), dtoConverterContext.getLocale()));
                this.setDepth(() -> ((CPInstance)cpInstance).getDepth());
                this.setDiscontinued(() -> ((CPInstance)cpInstance).isDiscontinued());
                this.setDiscontinuedDate(() -> ((CPInstance)cpInstance).getDiscontinuedDate());
                this.setDisplayDate(() -> ((CPInstance)cpInstance).getDisplayDate());
                this.setExpirationDate(() -> ((CPInstance)cpInstance).getExpirationDate());
                this.setExternalReferenceCode(() -> ((CPInstance)cpInstance).getExternalReferenceCode());
                this.setGtin(() -> ((CPInstance)cpInstance).getGtin());
                this.setHeight(() -> ((CPInstance)cpInstance).getHeight());
                this.setId(() -> ((CPInstance)cpInstance).getCPInstanceId());
                this.setManufacturerPartNumber(() -> ((CPInstance)cpInstance).getManufacturerPartNumber());
                this.setPrice(() -> ((CPInstance)cpInstance).getPrice());
                this.setProductId(() -> ((CPDefinition)cpDefinition).getCProductId());
                this.setProductName(() -> LanguageUtils.getLanguageIdMap((Map)cpDefinition.getNameMap()));
                this.setPromoPrice(() -> ((CPInstance)cpInstance).getPromoPrice());
                this.setPublished(() -> ((CPInstance)cpInstance).isPublished());
                this.setPurchasable(() -> ((CPInstance)cpInstance).isPurchasable());
                this.setReplacementSkuExternalReferenceCode(() -> {
                    if (replacementCPInstance != null) {
                        return replacementCPInstance.getExternalReferenceCode();
                    }
                    return null;
                });
                this.setReplacementSkuId(() -> {
                    if (replacementCPInstance != null) {
                        return replacementCPInstance.getCPInstanceId();
                    }
                    return null;
                });
                this.setSku(() -> ((CPInstance)cpInstance).getSku());
                this.setSkuOptions(() -> {
                    ArrayList<1> skuOptions = new ArrayList<1>();
                    List cpInstanceOptionValueRels = SkuDTOConverter.this._cpInstanceHelper.getCPInstanceCPInstanceOptionValueRels(cpInstance.getCPInstanceId());
                    for (CPInstanceOptionValueRel cpInstanceOptionValueRel : cpInstanceOptionValueRels) {
                        CPDefinitionOptionValueRel cpDefinitionOptionValueRel;
                        final CPDefinitionOptionRel cpDefinitionOptionRel = SkuDTOConverter.this._cpDefinitionOptionRelLocalService.fetchCPDefinitionOptionRel(cpInstanceOptionValueRel.getCPDefinitionOptionRelId());
                        if (cpDefinitionOptionRel == null || (cpDefinitionOptionValueRel = SkuDTOConverter.this._cpDefinitionOptionValueRelLocalService.fetchCPDefinitionOptionValueRel(cpInstanceOptionValueRel.getCPDefinitionOptionValueRelId())) == null) continue;
                        SkuOption skuOption = new SkuOption(){
                            {
                                this.setKey(() -> ((CPDefinitionOptionRel)cpDefinitionOptionRel).getKey());
                                this.setOptionId(() -> ((CPDefinitionOptionRel)cpDefinitionOptionRel).getCPDefinitionOptionRelId());
                                this.setOptionValueId(() -> ((CPDefinitionOptionValueRel)cpDefinitionOptionValueRel).getCPDefinitionOptionValueRelId());
                                this.setValue(() -> ((CPDefinitionOptionValueRel)cpDefinitionOptionValueRel).getKey());
                            }
                        };
                        skuOptions.add(skuOption);
                    }
                    return skuOptions.toArray(new SkuOption[0]);
                });
                this.setSkuUnitOfMeasures(() -> SkuDTOConverter.this._toSkuUnitOfMeasures(cpInstance, dtoConverterContext));
                this.setUnitOfMeasureKey(() -> {
                    if (cpInstanceUnitOfMeasure != null) {
                        return cpInstanceUnitOfMeasure.getKey();
                    }
                    return null;
                });
                this.setUnitOfMeasureName(() -> {
                    if (cpInstanceUnitOfMeasure != null) {
                        return LanguageUtils.getLanguageIdMap((Map)cpInstanceUnitOfMeasure.getNameMap());
                    }
                    return null;
                });
                this.setUnitOfMeasureSkuId(() -> {
                    if (cpInstanceUnitOfMeasure != null) {
                        return StringBundler.concat((Object[])new Object[]{cpInstance.getCPInstanceId(), "-", cpInstanceUnitOfMeasure.getCPInstanceUnitOfMeasureId()});
                    }
                    return String.valueOf(cpInstance.getCPInstanceId());
                });
                this.setUnspsc(() -> ((CPInstance)cpInstance).getUnspsc());
                this.setWeight(() -> ((CPInstance)cpInstance).getWeight());
                this.setWidth(() -> ((CPInstance)cpInstance).getWidth());
            }
        };
    }

    private SkuUnitOfMeasure[] _toSkuUnitOfMeasures(CPInstance cpInstance, DTOConverterContext dtoConverterContext) {
        return (SkuUnitOfMeasure[])TransformUtil.transformToArray((Collection)cpInstance.getCPInstanceUnitOfMeasures(-1, -1, null), cpInstanceUnitOfMeasure -> {
            DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext((Object)cpInstanceUnitOfMeasure.getCPInstanceUnitOfMeasureId(), dtoConverterContext.getLocale());
            defaultDTOConverterContext.setAttribute("id", (Object)cpInstance.getCPInstanceId());
            return (SkuUnitOfMeasure)this._skuUnitOfMeasureDTOConverter.toDTO((DTOConverterContext)defaultDTOConverterContext);
        }, SkuUnitOfMeasure.class);
    }
}

