/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.media.CommerceMediaResolver;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.type.virtual.model.CPDVirtualSettingFileEntry;
import com.liferay.commerce.product.type.virtual.model.CPDefinitionVirtualSetting;
import com.liferay.commerce.product.type.virtual.service.CPDefinitionVirtualSettingService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductVirtualSettings;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductVirtualSettingsFileEntry;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Status;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.model.CPDefinition"}, service={DTOConverter.class})
public class ProductVirtualSettingsDTOConverter
implements DTOConverter<CPDefinition, ProductVirtualSettings> {
    @Reference
    private CommerceMediaResolver _commerceMediaResolver;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPDefinitionVirtualSettingService _cpDefinitionVirtualSettingService;
    @Reference
    private Language _language;

    public String getContentType() {
        return ProductVirtualSettings.class.getSimpleName();
    }

    public ProductVirtualSettings toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinition cpDefinition = this._cpDefinitionService.getCPDefinition(((Long)dtoConverterContext.getId()).longValue());
        if (!"virtual".equals(cpDefinition.getProductTypeName())) {
            return null;
        }
        final CPDefinitionVirtualSetting cpDefinitionVirtualSetting = this._cpDefinitionVirtualSettingService.fetchCPDefinitionVirtualSetting(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId());
        if (cpDefinitionVirtualSetting == null) {
            return null;
        }
        final List cpdVirtualSettingFileEntries = cpDefinitionVirtualSetting.getCPDVirtualSettingFileEntries();
        return new ProductVirtualSettings(){
            {
                this.setActivationStatus(() -> ((CPDefinitionVirtualSetting)cpDefinitionVirtualSetting).getActivationStatus());
                this.setActivationStatusInfo(() -> {
                    final String orderStatusLabel = CommerceOrderConstants.getOrderStatusLabel((int)cpDefinitionVirtualSetting.getActivationStatus());
                    return new Status(){
                        {
                            this.setCode(() -> ((CPDefinitionVirtualSetting)cpDefinitionVirtualSetting).getActivationStatus());
                            this.setLabel(() -> orderStatusLabel);
                            this.setLabel_i18n(() -> ProductVirtualSettingsDTOConverter.this._language.get(dtoConverterContext.getLocale(), orderStatusLabel));
                        }
                    };
                });
                this.setDuration(() -> TimeUnit.MILLISECONDS.toDays(cpDefinitionVirtualSetting.getDuration()));
                this.setId(() -> ((CPDefinitionVirtualSetting)cpDefinitionVirtualSetting).getCPDefinitionVirtualSettingId());
                this.setMaxUsages(() -> ((CPDefinitionVirtualSetting)cpDefinitionVirtualSetting).getMaxUsages());
                this.setProductVirtualSettingsFileEntries(() -> ProductVirtualSettingsDTOConverter.this._toProductVirtualSettingsFileEntries(cpdVirtualSettingFileEntries, cpDefinition));
                this.setSampleSrc(() -> {
                    FileEntry fileEntry = cpDefinitionVirtualSetting.getSampleFileEntry();
                    if (fileEntry == null) {
                        return null;
                    }
                    return ProductVirtualSettingsDTOConverter.this._commerceMediaResolver.getDownloadVirtualProductSampleURL(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), Long.MIN_VALUE, fileEntry.getFileEntryId());
                });
                this.setSampleURL(() -> ((CPDefinitionVirtualSetting)cpDefinitionVirtualSetting).getSampleURL());
                this.setSrc(() -> {
                    if (cpdVirtualSettingFileEntries.isEmpty()) {
                        return null;
                    }
                    CPDVirtualSettingFileEntry cpdVirtualSettingFileEntry = (CPDVirtualSettingFileEntry)cpdVirtualSettingFileEntries.get(0);
                    long fileEntryId = cpdVirtualSettingFileEntry.getFileEntryId();
                    if (fileEntryId == 0L) {
                        return null;
                    }
                    return ProductVirtualSettingsDTOConverter.this._commerceMediaResolver.getDownloadVirtualProductURL(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), Long.MIN_VALUE, fileEntryId);
                });
                this.setTermsOfUseContent(() -> LanguageUtils.getLanguageIdMap((Map)cpDefinitionVirtualSetting.getTermsOfUseContentMap()));
                this.setTermsOfUseJournalArticleId(() -> {
                    JournalArticle journalArticle = cpDefinitionVirtualSetting.getTermsOfUseJournalArticle();
                    if (journalArticle == null) {
                        return null;
                    }
                    return journalArticle.getResourcePrimKey();
                });
                this.setTermsOfUseRequired(() -> ((CPDefinitionVirtualSetting)cpDefinitionVirtualSetting).isTermsOfUseRequired());
                this.setUrl(() -> {
                    if (cpdVirtualSettingFileEntries.isEmpty()) {
                        return null;
                    }
                    CPDVirtualSettingFileEntry cpdVirtualSettingFileEntry = (CPDVirtualSettingFileEntry)cpdVirtualSettingFileEntries.get(0);
                    if (Validator.isNull((String)cpdVirtualSettingFileEntry.getUrl())) {
                        return null;
                    }
                    return cpdVirtualSettingFileEntry.getUrl();
                });
                this.setUseSample(() -> ((CPDefinitionVirtualSetting)cpDefinitionVirtualSetting).isUseSample());
            }
        };
    }

    private ProductVirtualSettingsFileEntry[] _toProductVirtualSettingsFileEntries(List<CPDVirtualSettingFileEntry> cpdVirtualSettingFileEntries, CPDefinition cpDefinition) {
        return (ProductVirtualSettingsFileEntry[])TransformUtil.transformToArray(cpdVirtualSettingFileEntries, cpdVirtualSettingFileEntry -> new ProductVirtualSettingsFileEntry((CPDVirtualSettingFileEntry)cpdVirtualSettingFileEntry, cpDefinition){
            final /* synthetic */ CPDVirtualSettingFileEntry val$cpdVirtualSettingFileEntry;
            final /* synthetic */ CPDefinition val$cpDefinition;
            {
                this.val$cpdVirtualSettingFileEntry = cPDVirtualSettingFileEntry;
                this.val$cpDefinition = cPDefinition;
                this.setSrc(() -> {
                    long fileEntryId = this.val$cpdVirtualSettingFileEntry.getFileEntryId();
                    if (fileEntryId == 0L) {
                        return null;
                    }
                    return ProductVirtualSettingsDTOConverter.this._commerceMediaResolver.getDownloadVirtualProductURL(CPDefinition.class.getName(), this.val$cpDefinition.getCPDefinitionId(), Long.MIN_VALUE, fileEntryId);
                });
                this.setUrl(() -> {
                    if (Validator.isNull((String)this.val$cpdVirtualSettingFileEntry.getUrl())) {
                        return null;
                    }
                    return this.val$cpdVirtualSettingFileEntry.getUrl();
                });
                this.setVersion(() -> {
                    if (Validator.isNull((String)this.val$cpdVirtualSettingFileEntry.getVersion())) {
                        return null;
                    }
                    return this.val$cpdVirtualSettingFileEntry.getVersion();
                });
            }
        }, ProductVirtualSettingsFileEntry.class);
    }
}

