/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.model.CPOptionCategory;
import com.liferay.commerce.product.service.CPOptionCategoryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.OptionCategory;
import com.liferay.headless.commerce.admin.catalog.internal.odata.entity.v1_0.OptionCategoryEntityModel;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseOptionCategoryResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.OptionCategoryResource;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/option-category.properties"}, scope=ServiceScope.PROTOTYPE, service={OptionCategoryResource.class})
public class OptionCategoryResourceImpl
extends BaseOptionCategoryResourceImpl {
    private static final EntityModel _entityModel = new OptionCategoryEntityModel();
    @Reference
    private CPOptionCategoryService _cpOptionCategoryService;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.OptionCategoryDTOConverter)")
    private DTOConverter<CPOptionCategory, OptionCategory> _optionCategoryDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteOptionCategory(Long id) throws Exception {
        this._cpOptionCategoryService.deleteCPOptionCategory(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public void deleteOptionCategoryByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPOptionCategory cpOptionCategory = this._cpOptionCategoryService.getCPOptionCategoryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        this._cpOptionCategoryService.deleteCPOptionCategory(cpOptionCategory.getCPOptionCategoryId());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public Page<OptionCategory> getOptionCategoriesPage(Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)CPOptionCategory.class.getName(), (String)"", (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), (Sort[])sorts, document -> this._toOptionCategory(GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    @Override
    public OptionCategory getOptionCategory(Long id) throws Exception {
        return this._toOptionCategory(GetterUtil.getLong((Object)id));
    }

    @Override
    public OptionCategory getOptionCategoryByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPOptionCategory cpOptionCategory = this._cpOptionCategoryService.getCPOptionCategoryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        return this.getOptionCategory(cpOptionCategory.getCPOptionCategoryId());
    }

    @Override
    public Response patchOptionCategory(Long id, OptionCategory optionCategory) throws Exception {
        this._updateOptionCategory(id, optionCategory);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public OptionCategory patchOptionCategoryByExternalReferenceCode(String externalReferenceCode, OptionCategory optionCategory) throws Exception {
        CPOptionCategory cpOptionCategory = this._cpOptionCategoryService.getCPOptionCategoryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        this._updateOptionCategory(cpOptionCategory.getCPOptionCategoryId(), optionCategory);
        return this._toOptionCategory(cpOptionCategory.getCPOptionCategoryId());
    }

    @Override
    public OptionCategory postOptionCategory(OptionCategory optionCategory) throws Exception {
        return this._toOptionCategory(this._cpOptionCategoryService.addOrUpdateCPOptionCategory(GetterUtil.getString((String)optionCategory.getExternalReferenceCode()), GetterUtil.getLong((Object)optionCategory.getId()), LanguageUtils.getLocalizedMap((Map)optionCategory.getTitle()), LanguageUtils.getLocalizedMap((Map)optionCategory.getDescription()), (double)GetterUtil.getLong((Object)optionCategory.getPriority()), optionCategory.getKey(), this._serviceContextHelper.getServiceContext(this.contextUser)));
    }

    private OptionCategory _toOptionCategory(CPOptionCategory cpOptionCategory) throws Exception {
        return this._toOptionCategory(cpOptionCategory.getCPOptionCategoryId());
    }

    private OptionCategory _toOptionCategory(Long cpOptionCategoryId) throws Exception {
        return (OptionCategory)this._optionCategoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpOptionCategoryId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private CPOptionCategory _updateOptionCategory(Long id, OptionCategory optionCategory) throws Exception {
        Map descriptionMap;
        CPOptionCategory cpOptionCategory = this._cpOptionCategoryService.getCPOptionCategory(id.longValue());
        Map titleMap = optionCategory.getTitle();
        if (titleMap == null) {
            titleMap = LanguageUtils.getLanguageIdMap((Map)cpOptionCategory.getTitleMap());
        }
        if ((descriptionMap = optionCategory.getDescription()) == null) {
            descriptionMap = LanguageUtils.getLanguageIdMap((Map)cpOptionCategory.getDescriptionMap());
        }
        return this._cpOptionCategoryService.updateCPOptionCategory(GetterUtil.getString((String)optionCategory.getExternalReferenceCode(), (String)cpOptionCategory.getExternalReferenceCode()), cpOptionCategory.getCPOptionCategoryId(), LanguageUtils.getLocalizedMap((Map)titleMap), LanguageUtils.getLocalizedMap((Map)descriptionMap), GetterUtil.get((Object)optionCategory.getPriority(), (double)cpOptionCategory.getPriority()), optionCategory.getKey());
    }
}

