/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceEntryService;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPInstanceUnitOfMeasure;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.product.service.CPInstanceUnitOfMeasureLocalService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuUnitOfMeasure;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.model.CPInstanceUnitOfMeasure"}, service={DTOConverter.class})
public class SkuUnitOfMeasureDTOConverter
implements DTOConverter<CPInstanceUnitOfMeasure, SkuUnitOfMeasure> {
    @Reference
    private CommercePriceEntryService _commercePriceEntryService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private CPInstanceUnitOfMeasureLocalService _cpInstanceUnitOfMeasureLocalService;

    public String getContentType() {
        return CPInstanceUnitOfMeasure.class.getSimpleName();
    }

    public SkuUnitOfMeasure toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure = this._cpInstanceUnitOfMeasureLocalService.getCPInstanceUnitOfMeasure(((Long)dtoConverterContext.getId()).longValue());
        final CPInstance cpInstance = this._cpInstanceService.getCPInstance(cpInstanceUnitOfMeasure.getCPInstanceId());
        return new SkuUnitOfMeasure(){
            {
                this.setActions(() -> ((DTOConverterContext)dtoConverterContext).getActions());
                this.setActive(() -> ((CPInstanceUnitOfMeasure)cpInstanceUnitOfMeasure).isActive());
                this.setBasePrice(() -> SkuUnitOfMeasureDTOConverter.this._getInstanceBaseCommercePriceEntryPrice(cpInstance.getCPInstanceUuid(), cpInstanceUnitOfMeasure.getKey(), "price-list"));
                this.setId(() -> ((CPInstanceUnitOfMeasure)cpInstanceUnitOfMeasure).getCPInstanceUnitOfMeasureId());
                this.setIncrementalOrderQuantity(() -> {
                    BigDecimal incrementalOrderQuantity = cpInstanceUnitOfMeasure.getIncrementalOrderQuantity();
                    if (incrementalOrderQuantity == null) {
                        return null;
                    }
                    return incrementalOrderQuantity.setScale(cpInstanceUnitOfMeasure.getPrecision(), RoundingMode.HALF_UP);
                });
                this.setKey(() -> ((CPInstanceUnitOfMeasure)cpInstanceUnitOfMeasure).getKey());
                this.setName(() -> LanguageUtils.getLanguageIdMap((Map)cpInstanceUnitOfMeasure.getNameMap()));
                this.setPrecision(() -> ((CPInstanceUnitOfMeasure)cpInstanceUnitOfMeasure).getPrecision());
                this.setPrimary(() -> ((CPInstanceUnitOfMeasure)cpInstanceUnitOfMeasure).isPrimary());
                this.setPriority(() -> ((CPInstanceUnitOfMeasure)cpInstanceUnitOfMeasure).getPriority());
                this.setPromoPrice(() -> SkuUnitOfMeasureDTOConverter.this._getInstanceBaseCommercePriceEntryPrice(cpInstance.getCPInstanceUuid(), cpInstanceUnitOfMeasure.getKey(), "promotion"));
                this.setRate(() -> {
                    BigDecimal rate = cpInstanceUnitOfMeasure.getRate();
                    if (rate == null) {
                        return null;
                    }
                    return rate.setScale(cpInstanceUnitOfMeasure.getPrecision(), RoundingMode.HALF_UP);
                });
                this.setSku(() -> ((CPInstanceUnitOfMeasure)cpInstanceUnitOfMeasure).getSku());
                this.setSkuId(() -> ((CPInstanceUnitOfMeasure)cpInstanceUnitOfMeasure).getCPInstanceId());
            }
        };
    }

    private BigDecimal _getInstanceBaseCommercePriceEntryPrice(String cpInstanceUuid, String key, String type) throws Exception {
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.getInstanceBaseCommercePriceEntry(cpInstanceUuid, type, key);
        if (commercePriceEntry == null) {
            return null;
        }
        CommercePriceList commercePriceList = commercePriceEntry.getCommercePriceList();
        CommerceCurrency commerceCurrency = commercePriceList.getCommerceCurrency();
        return commerceCurrency.round(commercePriceEntry.getPrice());
    }
}

