/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPOptionCategory;
import com.liferay.commerce.product.model.CPSpecificationOption;
import com.liferay.commerce.product.service.CPSpecificationOptionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.OptionCategory;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Specification;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.headless.commerce.admin.catalog.dto.v1_0.Specification"}, service={DTOConverter.class})
public class SpecificationDTOConverter
implements DTOConverter<CPSpecificationOption, Specification> {
    @Reference
    private CPSpecificationOptionService _cpSpecificationOptionService;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.OptionCategoryDTOConverter)")
    private DTOConverter<CPOptionCategory, OptionCategory> _optionCategoryDTOConverter;

    public String getContentType() {
        return Specification.class.getSimpleName();
    }

    public Specification toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPSpecificationOption cpSpecificationOption = this._cpSpecificationOptionService.getCPSpecificationOption(((Long)dtoConverterContext.getId()).longValue());
        return new Specification(){
            {
                this.setDescription(() -> LanguageUtils.getLanguageIdMap((Map)cpSpecificationOption.getDescriptionMap()));
                this.setFacetable(() -> ((CPSpecificationOption)cpSpecificationOption).isFacetable());
                this.setId(() -> ((CPSpecificationOption)cpSpecificationOption).getCPSpecificationOptionId());
                this.setKey(() -> ((CPSpecificationOption)cpSpecificationOption).getKey());
                this.setOptionCategory(() -> {
                    CPOptionCategory cpOptionCategory = cpSpecificationOption.getCPOptionCategory();
                    if (cpOptionCategory == null) {
                        return null;
                    }
                    return (OptionCategory)SpecificationDTOConverter.this._optionCategoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpOptionCategory.getCPOptionCategoryId(), dtoConverterContext.getLocale()));
                });
                this.setPriority(() -> ((CPSpecificationOption)cpSpecificationOption).getPriority());
                this.setTitle(() -> LanguageUtils.getLanguageIdMap((Map)cpSpecificationOption.getTitleMap()));
            }
        };
    }
}

