/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.shop.by.diagram.model.CSDiagramEntry;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramEntryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.MappedProduct;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.shop.by.diagram.model.CSDiagramEntry"}, service={DTOConverter.class})
public class MappedProductDTOConverter
implements DTOConverter<CSDiagramEntry, MappedProduct> {
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private CSDiagramEntryService _csDiagramEntryService;

    public String getContentType() {
        return MappedProduct.class.getSimpleName();
    }

    public MappedProduct toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CSDiagramEntry csDiagramEntry = this._csDiagramEntryService.getCSDiagramEntry(((Long)dtoConverterContext.getId()).longValue());
        final CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(csDiagramEntry.getCProductId());
        return new MappedProduct(){
            {
                this.setActions(() -> ((DTOConverterContext)dtoConverterContext).getActions());
                this.setCustomFields(() -> CustomFieldsUtil.toCustomFields(dtoConverterContext.isAcceptAllLanguages(), CSDiagramEntry.class.getName(), csDiagramEntry.getCSDiagramEntryId(), csDiagramEntry.getCompanyId(), dtoConverterContext.getLocale()));
                this.setId(() -> ((CSDiagramEntry)csDiagramEntry).getCSDiagramEntryId());
                this.setProductExternalReferenceCode(() -> {
                    if (cpDefinition == null) {
                        return "";
                    }
                    CProduct cProduct = cpDefinition.getCProduct();
                    return cProduct.getExternalReferenceCode();
                });
                this.setProductId(() -> ((CSDiagramEntry)csDiagramEntry).getCProductId());
                this.setProductName(() -> {
                    if (cpDefinition == null) {
                        return null;
                    }
                    return LanguageUtils.getLanguageIdMap((Map)cpDefinition.getNameMap());
                });
                this.setQuantity(() -> ((CSDiagramEntry)csDiagramEntry).getQuantity());
                this.setSequence(() -> ((CSDiagramEntry)csDiagramEntry).getSequence());
                this.setSku(() -> ((CSDiagramEntry)csDiagramEntry).getSku());
                this.setSkuExternalReferenceCode(() -> {
                    CPInstance cpInstance = MappedProductDTOConverter.this._cpInstanceService.fetchCPInstance(GetterUtil.getLong((Object)csDiagramEntry.getCPInstanceId()));
                    if (cpInstance == null) {
                        return "";
                    }
                    return cpInstance.getExternalReferenceCode();
                });
                this.setSkuId(() -> GetterUtil.getLong((Object)csDiagramEntry.getCPInstanceId()));
                this.setType(() -> {
                    if (csDiagramEntry.isDiagram()) {
                        return MappedProduct.Type.create((String)MappedProduct.Type.DIAGRAM.getValue());
                    }
                    if (csDiagramEntry.getCPInstanceId() > 0L) {
                        return MappedProduct.Type.create((String)MappedProduct.Type.SKU.getValue());
                    }
                    return MappedProduct.Type.create((String)MappedProduct.Type.EXTERNAL.getValue());
                });
            }
        };
    }
}

