/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.model.CPDAvailabilityEstimate;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.model.CommerceAvailabilityEstimate;
import com.liferay.commerce.service.CPDAvailabilityEstimateService;
import com.liferay.commerce.service.CPDefinitionInventoryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfiguration;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.math.BigDecimal;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.model.CPDefinitionInventory"}, service={DTOConverter.class})
public class ProductConfigurationDTOConverter
implements DTOConverter<CPDefinitionInventory, ProductConfiguration> {
    @Reference
    private CPDAvailabilityEstimateService _cpdAvailabilityEstimateService;
    @Reference
    private CPDefinitionInventoryService _cpDefinitionInventoryService;

    public String getContentType() {
        return ProductConfiguration.class.getSimpleName();
    }

    public ProductConfiguration toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CPDAvailabilityEstimate cpdAvailabilityEstimate = this._cpdAvailabilityEstimateService.fetchCPDAvailabilityEstimateByCPDefinitionId(((Long)dtoConverterContext.getId()).longValue());
        final CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryService.fetchCPDefinitionInventoryByCPDefinitionId(((Long)dtoConverterContext.getId()).longValue());
        if (cpdAvailabilityEstimate == null && cpDefinitionInventory == null) {
            return new ProductConfiguration();
        }
        return new ProductConfiguration(){
            {
                this.setAllowBackOrder(() -> {
                    if (cpDefinitionInventory == null) {
                        return null;
                    }
                    return cpDefinitionInventory.isBackOrders();
                });
                this.setAllowedOrderQuantities(() -> {
                    if (cpDefinitionInventory == null) {
                        return null;
                    }
                    return cpDefinitionInventory.getAllowedOrderQuantitiesArray();
                });
                this.setAvailabilityEstimateId(() -> {
                    if (cpdAvailabilityEstimate == null) {
                        return null;
                    }
                    return cpdAvailabilityEstimate.getCommerceAvailabilityEstimateId();
                });
                this.setAvailabilityEstimateName(() -> {
                    if (cpdAvailabilityEstimate == null) {
                        return null;
                    }
                    CommerceAvailabilityEstimate commerceAvailabilityEstimate = cpdAvailabilityEstimate.getCommerceAvailabilityEstimate();
                    if (commerceAvailabilityEstimate == null) {
                        return null;
                    }
                    return LanguageUtils.getLanguageIdMap((Map)commerceAvailabilityEstimate.getTitleMap());
                });
                this.setInventoryEngine(() -> {
                    if (cpDefinitionInventory == null) {
                        return null;
                    }
                    return cpDefinitionInventory.getCPDefinitionInventoryEngine();
                });
                this.setMaxOrderQuantity(() -> {
                    if (cpDefinitionInventory == null) {
                        return null;
                    }
                    return BigDecimalUtil.stripTrailingZeros((BigDecimal)cpDefinitionInventory.getMaxOrderQuantity());
                });
                this.setMinOrderQuantity(() -> {
                    if (cpDefinitionInventory == null) {
                        return null;
                    }
                    return BigDecimalUtil.stripTrailingZeros((BigDecimal)cpDefinitionInventory.getMinOrderQuantity());
                });
                this.setMultipleOrderQuantity(() -> {
                    if (cpDefinitionInventory == null) {
                        return null;
                    }
                    return BigDecimalUtil.stripTrailingZeros((BigDecimal)cpDefinitionInventory.getMultipleOrderQuantity());
                });
            }
        };
    }
}

