/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Currency;
import com.liferay.headless.commerce.admin.catalog.internal.odata.entity.v1_0.CurrencyEntityModel;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseCurrencyResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.CurrencyResource;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/currency.properties"}, scope=ServiceScope.PROTOTYPE, service={CurrencyResource.class})
public class CurrencyResourceImpl
extends BaseCurrencyResourceImpl {
    private static final EntityModel _entityModel = new CurrencyEntityModel();
    @Reference
    private CommerceCurrencyService _commerceCurrencyService;
    @Reference
    private Localization _localization;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteCurrency(Long id) throws Exception {
        this._checkFeatureFlag();
        this._commerceCurrencyService.deleteCommerceCurrency(id.longValue());
    }

    @Override
    public Page<Currency> getCurrenciesPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        this._checkFeatureFlag();
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)CommerceCurrency.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), (Sort[])sorts, document -> this._toCurrency(GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    @Override
    public Currency getCurrency(Long id) throws Exception {
        this._checkFeatureFlag();
        return this._toCurrency(this._commerceCurrencyService.getCommerceCurrency(id.longValue()));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public Currency patchCurrency(Long id, Currency currency) throws Exception {
        Map formatPatternMap;
        this._checkFeatureFlag();
        CommerceCurrency commerceCurrency = this._commerceCurrencyService.getCommerceCurrency(id.longValue());
        Map nameMap = currency.getName();
        if (nameMap == null) {
            nameMap = LanguageUtils.getLanguageIdMap((Map)commerceCurrency.getNameMap());
        }
        if ((formatPatternMap = currency.getFormatPattern()) == null) {
            formatPatternMap = LanguageUtils.getLanguageIdMap((Map)commerceCurrency.getFormatPatternMap());
        }
        return this._toCurrency(this._commerceCurrencyService.updateCommerceCurrency(commerceCurrency.getCommerceCurrencyId(), LanguageUtils.getLocalizedMap((Map)nameMap), GetterUtil.getString((String)currency.getSymbol(), (String)commerceCurrency.getSymbol()), (BigDecimal)GetterUtil.getNumber((Object)currency.getRate(), (Number)commerceCurrency.getRate()), LanguageUtils.getLocalizedMap((Map)formatPatternMap), GetterUtil.getInteger((Object)currency.getMaxFractionDigits(), (int)commerceCurrency.getMaxFractionDigits()), GetterUtil.getInteger((Object)currency.getMinFractionDigits(), (int)commerceCurrency.getMinFractionDigits()), GetterUtil.getString((String)currency.getRoundingModeAsString(), (String)commerceCurrency.getRoundingMode()), GetterUtil.getBoolean((Object)currency.getPrimary(), (boolean)commerceCurrency.isPrimary()), GetterUtil.getDouble((Object)currency.getPriority(), (double)commerceCurrency.getPriority()), GetterUtil.getBoolean((Object)currency.getActive(), (boolean)commerceCurrency.isActive()), this._serviceContextHelper.getServiceContext(this.contextUser.getUserId())));
    }

    @Override
    public Currency postCurrency(Currency currency) throws Exception {
        this._checkFeatureFlag();
        Map formatPatternMap = LanguageUtils.getLocalizedMap((Map)currency.getFormatPattern());
        if (formatPatternMap == null) {
            formatPatternMap = this._localization.getLocalizationMap("###,##0.00");
        }
        return this._toCurrency(this._commerceCurrencyService.addCommerceCurrency(currency.getCode(), LanguageUtils.getLocalizedMap((Map)currency.getName()), GetterUtil.getString((String)currency.getSymbol()), (BigDecimal)GetterUtil.getNumber((Object)currency.getRate()), formatPatternMap, GetterUtil.getInteger((Object)currency.getMaxFractionDigits(), (int)2), GetterUtil.getInteger((Object)currency.getMinFractionDigits(), (int)2), GetterUtil.getString((String)currency.getRoundingModeAsString(), (String)Currency.RoundingMode.HALF_EVEN.getValue()), GetterUtil.getBoolean((Object)currency.getPrimary()), GetterUtil.getDouble((Object)currency.getPriority()), GetterUtil.getBoolean((Object)currency.getActive())));
    }

    private void _checkFeatureFlag() throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"COMMERCE-12170")) {
            throw new UnsupportedOperationException();
        }
    }

    private Currency _toCurrency(CommerceCurrency commerceCurrency) throws Exception {
        return this._toCurrency(commerceCurrency.getCommerceCurrencyId());
    }

    private Currency _toCurrency(Long commerceCurrencyId) throws Exception {
        final CommerceCurrency commerceCurrency = this._commerceCurrencyService.getCommerceCurrency(commerceCurrencyId.longValue());
        return new Currency(){
            {
                this.setActive(() -> ((CommerceCurrency)commerceCurrency).isActive());
                this.setCode(() -> ((CommerceCurrency)commerceCurrency).getCode());
                this.setFormatPattern(() -> LanguageUtils.getLanguageIdMap((Map)commerceCurrency.getFormatPatternMap()));
                this.setId(() -> ((CommerceCurrency)commerceCurrency).getCommerceCurrencyId());
                this.setMaxFractionDigits(() -> ((CommerceCurrency)commerceCurrency).getMaxFractionDigits());
                this.setMinFractionDigits(() -> ((CommerceCurrency)commerceCurrency).getMinFractionDigits());
                this.setName(() -> LanguageUtils.getLanguageIdMap((Map)commerceCurrency.getNameMap()));
                this.setPrimary(() -> ((CommerceCurrency)commerceCurrency).isPrimary());
                this.setPriority(() -> ((CommerceCurrency)commerceCurrency).getPriority());
                this.setRate(() -> ((CommerceCurrency)commerceCurrency).getRate());
                this.setRoundingMode(() -> Currency.RoundingMode.valueOf((String)commerceCurrency.getRoundingMode()));
                this.setSymbol(() -> ((CommerceCurrency)commerceCurrency).getSymbol());
            }
        };
    }
}

