/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductShippingConfiguration;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductShippingConfigurationResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductShippingConfigurationUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductShippingConfigurationResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/product-shipping-configuration.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={ProductShippingConfigurationResource.class})
public class ProductShippingConfigurationResourceImpl
extends BaseProductShippingConfigurationResourceImpl {
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductShippingConfigurationDTOConverter)")
    private DTOConverter<CPDefinition, ProductShippingConfiguration> _productShippingConfigurationDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public ProductShippingConfiguration getProductByExternalReferenceCodeShippingConfiguration(String externalReferenceCode) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._toProductShippingConfiguration(cpDefinition.getCPDefinitionId());
    }

    @Override
    @NestedField(parentClass=Product.class, value="shippingConfiguration")
    public ProductShippingConfiguration getProductIdShippingConfiguration(@NestedFieldId(value="productId") Long id) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + id);
        }
        return this._toProductShippingConfiguration(cpDefinition.getCPDefinitionId());
    }

    @Override
    public Response patchProductByExternalReferenceCodeShippingConfiguration(String externalReferenceCode, ProductShippingConfiguration productShippingConfiguration) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        this._updateProductShippingConfiguration(cpDefinition, productShippingConfiguration);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchProductIdShippingConfiguration(Long id, ProductShippingConfiguration productShippingConfiguration) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + id);
        }
        this._updateProductShippingConfiguration(cpDefinition, productShippingConfiguration);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    private ProductShippingConfiguration _toProductShippingConfiguration(Long cpDefinitionId) throws Exception {
        return (ProductShippingConfiguration)this._productShippingConfigurationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpDefinitionId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private ProductShippingConfiguration _updateProductShippingConfiguration(CPDefinition cpDefinition, ProductShippingConfiguration productShippingConfiguration) throws Exception {
        cpDefinition = ProductShippingConfigurationUtil.updateCPDefinitionShippingInfo(this._cpDefinitionService, productShippingConfiguration, cpDefinition, this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId()));
        return this._toProductShippingConfiguration(cpDefinition.getCPDefinitionId());
    }
}

