/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.media.CommerceMediaResolver;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.product.type.virtual.model.CPDVirtualSettingFileEntry;
import com.liferay.commerce.product.type.virtual.model.CPDefinitionVirtualSetting;
import com.liferay.commerce.product.type.virtual.service.CPDefinitionVirtualSettingService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuVirtualSettings;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuVirtualSettingsFileEntry;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Status;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuVirtualSettings"}, service={DTOConverter.class})
public class SkuVirtualSettingsDTOConverter
implements DTOConverter<CPInstance, SkuVirtualSettings> {
    @Reference
    private CommerceMediaResolver _commerceMediaResolver;
    @Reference
    private CPDefinitionVirtualSettingService _cpDefinitionVirtualSettingService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private Language _language;

    public String getContentType() {
        return SkuVirtualSettings.class.getSimpleName();
    }

    public SkuVirtualSettings toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPInstance cpInstance = this._cpInstanceService.getCPInstance(((Long)dtoConverterContext.getId()).longValue());
        CPDefinition cpDefinition = cpInstance.getCPDefinition();
        if (!"virtual".equals(cpDefinition.getProductTypeName())) {
            return null;
        }
        final CPDefinitionVirtualSetting cpDefinitionVirtualSetting = this._cpDefinitionVirtualSettingService.fetchCPDefinitionVirtualSetting(CPInstance.class.getName(), cpInstance.getCPInstanceId());
        if (cpDefinitionVirtualSetting == null) {
            return null;
        }
        final List cpdVirtualSettingFileEntries = cpDefinitionVirtualSetting.getCPDVirtualSettingFileEntries();
        return new SkuVirtualSettings(){
            {
                this.setActivationStatus(() -> ((CPDefinitionVirtualSetting)cpDefinitionVirtualSetting).getActivationStatus());
                this.setActivationStatusInfo(() -> {
                    final String orderStatusLabel = CommerceOrderConstants.getOrderStatusLabel((int)cpDefinitionVirtualSetting.getActivationStatus());
                    return new Status(){
                        {
                            this.setCode(() -> ((CPDefinitionVirtualSetting)cpDefinitionVirtualSetting).getActivationStatus());
                            this.setLabel(() -> orderStatusLabel);
                            this.setLabel_i18n(() -> SkuVirtualSettingsDTOConverter.this._language.get(dtoConverterContext.getLocale(), orderStatusLabel));
                        }
                    };
                });
                this.setDuration(() -> TimeUnit.MILLISECONDS.toDays(cpDefinitionVirtualSetting.getDuration()));
                this.setMaxUsages(() -> ((CPDefinitionVirtualSetting)cpDefinitionVirtualSetting).getMaxUsages());
                this.setOverride(() -> ((CPDefinitionVirtualSetting)cpDefinitionVirtualSetting).isOverride());
                this.setSampleSrc(() -> {
                    FileEntry fileEntry = cpDefinitionVirtualSetting.getSampleFileEntry();
                    if (fileEntry == null) {
                        return null;
                    }
                    return SkuVirtualSettingsDTOConverter.this._commerceMediaResolver.getDownloadVirtualProductSampleURL(CPInstance.class.getName(), cpInstance.getCPInstanceId(), Long.MIN_VALUE, fileEntry.getFileEntryId());
                });
                this.setSampleURL(() -> ((CPDefinitionVirtualSetting)cpDefinitionVirtualSetting).getSampleURL());
                this.setSkuVirtualSettingsFileEntries(() -> SkuVirtualSettingsDTOConverter.this._toSkuVirtualSettingsFileEntries(cpdVirtualSettingFileEntries, cpInstance));
                this.setSrc(() -> {
                    if (cpdVirtualSettingFileEntries.isEmpty()) {
                        return null;
                    }
                    CPDVirtualSettingFileEntry cpdVirtualSettingFileEntry = (CPDVirtualSettingFileEntry)cpdVirtualSettingFileEntries.get(0);
                    long fileEntryId = cpdVirtualSettingFileEntry.getFileEntryId();
                    if (fileEntryId == 0L) {
                        return null;
                    }
                    return SkuVirtualSettingsDTOConverter.this._commerceMediaResolver.getDownloadVirtualProductURL(CPInstance.class.getName(), cpInstance.getCPDefinitionId(), Long.MIN_VALUE, fileEntryId);
                });
                this.setTermsOfUseContent(() -> LanguageUtils.getLanguageIdMap((Map)cpDefinitionVirtualSetting.getTermsOfUseContentMap()));
                this.setTermsOfUseJournalArticleId(() -> {
                    JournalArticle journalArticle = cpDefinitionVirtualSetting.getTermsOfUseJournalArticle();
                    if (journalArticle == null) {
                        return null;
                    }
                    return journalArticle.getResourcePrimKey();
                });
                this.setTermsOfUseRequired(() -> ((CPDefinitionVirtualSetting)cpDefinitionVirtualSetting).isTermsOfUseRequired());
                this.setUrl(() -> {
                    if (cpdVirtualSettingFileEntries.isEmpty()) {
                        return null;
                    }
                    CPDVirtualSettingFileEntry cpdVirtualSettingFileEntry = (CPDVirtualSettingFileEntry)cpdVirtualSettingFileEntries.get(0);
                    if (Validator.isNull((String)cpdVirtualSettingFileEntry.getUrl())) {
                        return null;
                    }
                    return cpdVirtualSettingFileEntry.getUrl();
                });
                this.setUseSample(() -> ((CPDefinitionVirtualSetting)cpDefinitionVirtualSetting).isUseSample());
            }
        };
    }

    private SkuVirtualSettingsFileEntry[] _toSkuVirtualSettingsFileEntries(List<CPDVirtualSettingFileEntry> cpdVirtualSettingFileEntries, CPInstance cpInstance) {
        return (SkuVirtualSettingsFileEntry[])TransformUtil.transformToArray(cpdVirtualSettingFileEntries, cpdVirtualSettingFileEntry -> new SkuVirtualSettingsFileEntry((CPDVirtualSettingFileEntry)cpdVirtualSettingFileEntry, cpInstance){
            final /* synthetic */ CPDVirtualSettingFileEntry val$cpdVirtualSettingFileEntry;
            final /* synthetic */ CPInstance val$cpInstance;
            {
                this.val$cpdVirtualSettingFileEntry = cPDVirtualSettingFileEntry;
                this.val$cpInstance = cPInstance;
                this.setSrc(() -> {
                    long fileEntryId = this.val$cpdVirtualSettingFileEntry.getFileEntryId();
                    if (fileEntryId == 0L) {
                        return null;
                    }
                    return SkuVirtualSettingsDTOConverter.this._commerceMediaResolver.getDownloadVirtualProductURL(CPInstance.class.getName(), this.val$cpInstance.getCPInstanceId(), Long.MIN_VALUE, fileEntryId);
                });
                this.setUrl(() -> {
                    if (Validator.isNull((String)this.val$cpdVirtualSettingFileEntry.getUrl())) {
                        return null;
                    }
                    return this.val$cpdVirtualSettingFileEntry.getUrl();
                });
                this.setVersion(() -> {
                    if (Validator.isNull((String)this.val$cpdVirtualSettingFileEntry.getVersion())) {
                        return null;
                    }
                    return this.val$cpdVirtualSettingFileEntry.getVersion();
                });
            }
        }, SkuVirtualSettingsFileEntry.class);
    }
}

