/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetTagModel;
import com.liferay.asset.kernel.service.AssetTagService;
import com.liferay.commerce.media.CommerceMediaResolver;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.service.CPAttachmentFileEntryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Attachment;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.model.CPAttachmentFileEntry"}, service={DTOConverter.class})
public class AttachmentDTOConverter
implements DTOConverter<CPAttachmentFileEntry, Attachment> {
    @Reference
    private AssetTagService _assetTagService;
    @Reference
    private CommerceMediaResolver _commerceMediaResolver;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CPAttachmentFileEntryService _cpAttachmentFileEntryService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;

    public String getContentType() {
        return Attachment.class.getSimpleName();
    }

    public Attachment toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPAttachmentFileEntry cpAttachmentFileEntry = this._cpAttachmentFileEntryService.getCPAttachmentFileEntry(((Long)dtoConverterContext.getId()).longValue());
        return new Attachment(){
            {
                this.setCdnEnabled(() -> ((CPAttachmentFileEntry)cpAttachmentFileEntry).isCDNEnabled());
                this.setCdnURL(() -> ((CPAttachmentFileEntry)cpAttachmentFileEntry).getCDNURL());
                this.setCustomFields(() -> CustomFieldsUtil.toCustomFields(dtoConverterContext.isAcceptAllLanguages(), CPAttachmentFileEntry.class.getName(), cpAttachmentFileEntry.getCPAttachmentFileEntryId(), cpAttachmentFileEntry.getCompanyId(), dtoConverterContext.getLocale()));
                this.setDisplayDate(() -> ((CPAttachmentFileEntry)cpAttachmentFileEntry).getDisplayDate());
                this.setExpirationDate(() -> ((CPAttachmentFileEntry)cpAttachmentFileEntry).getExpirationDate());
                this.setExternalReferenceCode(() -> ((CPAttachmentFileEntry)cpAttachmentFileEntry).getExternalReferenceCode());
                this.setFileEntryId(() -> ((CPAttachmentFileEntry)cpAttachmentFileEntry).getFileEntryId());
                this.setGalleryEnabled(() -> ((CPAttachmentFileEntry)cpAttachmentFileEntry).isGalleryEnabled());
                this.setId(() -> ((CPAttachmentFileEntry)cpAttachmentFileEntry).getCPAttachmentFileEntryId());
                this.setOptions(() -> AttachmentDTOConverter.this._getAttachmentOptions(cpAttachmentFileEntry));
                this.setPriority(() -> ((CPAttachmentFileEntry)cpAttachmentFileEntry).getPriority());
                this.setSrc(() -> {
                    Company company = AttachmentDTOConverter.this._companyLocalService.getCompany(cpAttachmentFileEntry.getCompanyId());
                    String portalURL = AttachmentDTOConverter.this._portal.getPortalURL(company.getVirtualHostname(), AttachmentDTOConverter.this._portal.getPortalServerPort(false), true);
                    String downloadURL = AttachmentDTOConverter.this._commerceMediaResolver.getDownloadURL(Long.MIN_VALUE, cpAttachmentFileEntry.getCPAttachmentFileEntryId());
                    return portalURL + downloadURL;
                });
                this.setTags(() -> (String[])TransformUtil.transformToArray((Collection)AttachmentDTOConverter.this._assetTagService.getTags(cpAttachmentFileEntry.getModelClassName(), cpAttachmentFileEntry.getCPAttachmentFileEntryId()), AssetTagModel::getName, String.class));
                this.setTitle(() -> LanguageUtils.getLanguageIdMap((Map)cpAttachmentFileEntry.getTitleMap()));
                this.setType(() -> ((CPAttachmentFileEntry)cpAttachmentFileEntry).getType());
            }
        };
    }

    private Map<String, String> _getAttachmentOptions(CPAttachmentFileEntry cpAttachmentFileEntry) throws Exception {
        String json = cpAttachmentFileEntry.getJson();
        if (Validator.isNull((String)json)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> options = new HashMap<String, String>();
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (Object element : jsonArray) {
            JSONObject jsonObject = (JSONObject)element;
            if (!jsonObject.has("key")) continue;
            options.put(jsonObject.getString("key"), jsonObject.getString("value"));
        }
        return options;
    }
}

