/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.service.CPDefinitionOptionRelService;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelService;
import com.liferay.commerce.product.service.CPOptionLocalService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductOption;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductOptionValue;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.model.CPDefinitionOptionRel"}, service={DTOConverter.class})
public class ProductOptionDTOConverter
implements DTOConverter<CPDefinitionOptionRel, ProductOption> {
    @Reference
    private CPDefinitionOptionRelService _cpDefinitionOptionRelService;
    @Reference
    private CPDefinitionOptionValueRelService _cpDefinitionOptionValueRelService;
    @Reference
    private CPOptionLocalService _cpOptionLocalService;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductOptionValueDTOConverter)")
    private DTOConverter<CPDefinitionOptionValueRel, ProductOptionValue> _productOptionValueDTOConverter;

    public String getContentType() {
        return ProductOption.class.getSimpleName();
    }

    public ProductOption toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinitionOptionRel cpDefinitionOptionRel = this._cpDefinitionOptionRelService.getCPDefinitionOptionRel(((Long)dtoConverterContext.getId()).longValue());
        return new ProductOption(){
            {
                this.customFields = CustomFieldsUtil.toCustomFields(dtoConverterContext.isAcceptAllLanguages(), CPDefinitionOptionRel.class.getName(), cpDefinitionOptionRel.getCPDefinitionOptionRelId(), cpDefinitionOptionRel.getCompanyId(), dtoConverterContext.getLocale());
                this.description = LanguageUtils.getLanguageIdMap((Map)cpDefinitionOptionRel.getDescriptionMap());
                this.facetable = cpDefinitionOptionRel.isFacetable();
                this.fieldType = cpDefinitionOptionRel.getCommerceOptionTypeKey();
                this.id = cpDefinitionOptionRel.getCPDefinitionOptionRelId();
                this.key = cpDefinitionOptionRel.getKey();
                this.name = LanguageUtils.getLanguageIdMap((Map)cpDefinitionOptionRel.getNameMap());
                this.priceType = cpDefinitionOptionRel.getPriceType();
                this.required = cpDefinitionOptionRel.isRequired();
                this.skuContributor = cpDefinitionOptionRel.isSkuContributor();
                this.typeSettings = cpDefinitionOptionRel.getTypeSettings();
                this.setOptionId(() -> {
                    CPOption cpOption = ProductOptionDTOConverter.this._cpOptionLocalService.fetchCPOption(cpDefinitionOptionRel.getCPOptionId());
                    if (cpOption == null) {
                        return null;
                    }
                    return cpOption.getCPOptionId();
                });
                this.setProductOptionValues(() -> {
                    if (!GetterUtil.getBoolean((Object)dtoConverterContext.getAttribute("showProductOptionValues"))) {
                        return null;
                    }
                    return ProductOptionDTOConverter.this._toProductOptionValues(cpDefinitionOptionRel, dtoConverterContext);
                });
            }
        };
    }

    private ProductOptionValue[] _toProductOptionValues(CPDefinitionOptionRel cpDefinitionOptionRel, DTOConverterContext dtoConverterContext) throws Exception {
        List cpDefinitionOptionValueRels = this._cpDefinitionOptionValueRelService.getCPDefinitionOptionValueRels(cpDefinitionOptionRel.getCPDefinitionOptionRelId(), -1, -1);
        ArrayList<Object> productOptionValues = new ArrayList<Object>();
        for (CPDefinitionOptionValueRel cpDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
            productOptionValues.add(this._productOptionValueDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId(), dtoConverterContext.getLocale()), (Object)cpDefinitionOptionValueRel));
        }
        return productOptionValues.toArray(new ProductOptionValue[0]);
    }
}

