/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.account.model.AccountGroup;
import com.liferay.account.model.AccountGroupRel;
import com.liferay.account.service.AccountGroupLocalService;
import com.liferay.account.service.AccountGroupRelLocalService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductAccountGroup;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductAccountGroupResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductAccountGroupResource;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Collections;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/product-account-group.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={ProductAccountGroupResource.class})
public class ProductAccountGroupResourceImpl
extends BaseProductAccountGroupResourceImpl {
    @Reference
    private AccountGroupLocalService _accountGroupLocalService;
    @Reference
    private AccountGroupRelLocalService _accountGroupRelLocalService;
    @Reference
    private CPDefinitionService _cpDefinitionService;

    @Override
    public void deleteProductAccountGroup(Long id) throws Exception {
        this._accountGroupRelLocalService.deleteAccountGroupRel(id.longValue());
    }

    @Override
    public ProductAccountGroup getProductAccountGroup(Long id) throws Exception {
        return this.toProductAccountGroup(this._accountGroupRelLocalService.getAccountGroupRel(id.longValue()));
    }

    @Override
    public Page<ProductAccountGroup> getProductByExternalReferenceCodeProductAccountGroupsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            return Page.of(Collections.emptyList());
        }
        return Page.of(this.transform(this._accountGroupRelLocalService.getAccountGroupRels(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), pagination.getStartPosition(), pagination.getEndPosition(), null), this::toProductAccountGroup), (Pagination)pagination, (long)this._accountGroupRelLocalService.getAccountGroupRelsCount(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId()));
    }

    @Override
    @NestedField(parentClass=Product.class, value="productAccountGroups")
    public Page<ProductAccountGroup> getProductIdProductAccountGroupsPage(@NestedFieldId(value="productId") Long id, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            return Page.of(Collections.emptyList());
        }
        return Page.of(this.transform(this._accountGroupRelLocalService.getAccountGroupRels(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), pagination.getStartPosition(), pagination.getEndPosition(), null), this::toProductAccountGroup), (Pagination)pagination, (long)this._accountGroupRelLocalService.getAccountGroupRelsCount(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId()));
    }

    public ProductAccountGroup toProductAccountGroup(final AccountGroupRel accountGroupRel) throws Exception {
        final AccountGroup accountGroup = this._accountGroupLocalService.getAccountGroup(accountGroupRel.getAccountGroupId());
        return new ProductAccountGroup(){
            {
                this.accountGroupId = accountGroupRel.getAccountGroupId();
                this.externalReferenceCode = accountGroup.getExternalReferenceCode();
                this.id = accountGroupRel.getAccountGroupRelId();
                this.name = accountGroup.getName();
            }
        };
    }
}

