/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.pricing.exception.NoSuchPricingClassException;
import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.commerce.pricing.model.CommercePricingClassCPDefinitionRel;
import com.liferay.commerce.pricing.service.CommercePricingClassCPDefinitionRelService;
import com.liferay.commerce.pricing.service.CommercePricingClassService;
import com.liferay.commerce.product.exception.NoSuchCProductException;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductGroup;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductGroupProduct;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductGroupDTOConverter;
import com.liferay.headless.commerce.admin.catalog.internal.odata.entity.v1_0.ProductGroupEntityModel;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductGroupResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductGroupProductUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductGroupResource;
import com.liferay.headless.commerce.core.util.ExpandoUtil;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/product-group.properties"}, scope=ServiceScope.PROTOTYPE, service={ProductGroupResource.class})
public class ProductGroupResourceImpl
extends BaseProductGroupResourceImpl
implements EntityModelResource {
    private static final EntityModel _entityModel = new ProductGroupEntityModel();
    @Reference
    private CommercePricingClassCPDefinitionRelService _commercePricingClassCPDefinitionRelService;
    @Reference
    private CommercePricingClassService _commercePricingClassService;
    @Reference
    private CProductLocalService _cProductLocalService;
    @Reference
    private ProductGroupDTOConverter _productGroupDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteProductGroup(Long id) throws Exception {
        this._commercePricingClassService.deleteCommercePricingClass(id.longValue());
    }

    @Override
    public void deleteProductGroupByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommercePricingClass commercePricingClass = this._commercePricingClassService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePricingClass == null) {
            throw new NoSuchPricingClassException("Unable to find Product Group with externalReferenceCode: " + externalReferenceCode);
        }
        this._commercePricingClassService.deleteCommercePricingClass(commercePricingClass.getCommercePricingClassId());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public ProductGroup getProductGroup(Long id) throws Exception {
        return this._toProductGroup(GetterUtil.getLong((Object)id));
    }

    @Override
    public ProductGroup getProductGroupByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommercePricingClass commercePricingClass = this._commercePricingClassService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePricingClass == null) {
            throw new NoSuchPricingClassException("Unable to find Product Group with externalReferenceCode: " + externalReferenceCode);
        }
        return this._toProductGroup(commercePricingClass.getCommercePricingClassId());
    }

    @Override
    public Page<ProductGroup> getProductGroupsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(null, booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)CommercePricingClass.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), (UnsafeConsumer)new UnsafeConsumer(){

            public void accept(Object object) throws Exception {
                SearchContext searchContext = (SearchContext)object;
                searchContext.setCompanyId(ProductGroupResourceImpl.this.contextCompany.getCompanyId());
            }
        }, (Sort[])sorts, document -> this._toProductGroup(GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    @Override
    public Response patchProductGroup(Long id, ProductGroup productGroup) throws Exception {
        this._updateProductGroup(this._commercePricingClassService.getCommercePricingClass(id.longValue()), productGroup);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchProductGroupByExternalReferenceCode(String externalReferenceCode, ProductGroup productGroup) throws Exception {
        CommercePricingClass commercePricingClass = this._commercePricingClassService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePricingClass == null) {
            throw new NoSuchPricingClassException("Unable to find Product Group with externalReferenceCode: " + externalReferenceCode);
        }
        this._updateProductGroup(commercePricingClass, productGroup);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public ProductGroup postProductGroup(ProductGroup productGroup) throws Exception {
        CommercePricingClass commercePricingClass = this._addOrUpdateProductGroup(productGroup);
        return this._toProductGroup(commercePricingClass.getCommercePricingClassId());
    }

    private CommercePricingClass _addOrUpdateProductGroup(ProductGroup productGroup) throws Exception {
        CommercePricingClass commercePricingClass = this._commercePricingClassService.addOrUpdateCommercePricingClass(productGroup.getExternalReferenceCode(), 0L, this.contextUser.getUserId(), LanguageUtils.getLocalizedMap((Map)productGroup.getTitle()), LanguageUtils.getLocalizedMap((Map)productGroup.getDescription()), this._serviceContextHelper.getServiceContext());
        return this._updateNestedResources(productGroup, commercePricingClass);
    }

    private ProductGroup _toProductGroup(Long commercePricingClassId) throws Exception {
        return this._productGroupDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commercePricingClassId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private CommercePricingClass _updateNestedResources(ProductGroup productGroup, CommercePricingClass commercePricingClass) throws Exception {
        ProductGroupProduct[] productGroupProducts = productGroup.getProducts();
        if (productGroupProducts != null) {
            for (ProductGroupProduct productGroupProduct : productGroupProducts) {
                CProduct cProduct = this._cProductLocalService.fetchCProduct(productGroupProduct.getProductId().longValue());
                if (cProduct == null) {
                    cProduct = this._cProductLocalService.fetchCProductByExternalReferenceCode(this.contextCompany.getCompanyId(), productGroupProduct.getProductExternalReferenceCode());
                }
                if (cProduct == null) {
                    String productExternalReferenceCode = productGroupProduct.getProductExternalReferenceCode();
                    throw new NoSuchCProductException("Unable to find Product with externalReferenceCode: " + productExternalReferenceCode);
                }
                CommercePricingClassCPDefinitionRel commercePricingClassCPDefinitionRel = this._commercePricingClassCPDefinitionRelService.fetchCommercePricingClassCPDefinitionRel(commercePricingClass.getCommercePricingClassId(), cProduct.getPublishedCPDefinitionId());
                if (commercePricingClassCPDefinitionRel != null) continue;
                ProductGroupProductUtil.addCommercePricingClassCPDefinitionRel(this._cProductLocalService, this._commercePricingClassCPDefinitionRelService, productGroupProduct, commercePricingClass, this._serviceContextHelper);
            }
        }
        return commercePricingClass;
    }

    private CommercePricingClass _updateProductGroup(CommercePricingClass commercePricingClass, ProductGroup productGroup) throws Exception {
        commercePricingClass = this._commercePricingClassService.updateCommercePricingClass(commercePricingClass.getCommercePricingClassId(), commercePricingClass.getUserId(), LanguageUtils.getLocalizedMap((Map)productGroup.getTitle()), LanguageUtils.getLocalizedMap((Map)productGroup.getDescription()), this._serviceContextHelper.getServiceContext());
        Map customFields = productGroup.getCustomFields();
        if (customFields != null && !customFields.isEmpty()) {
            ExpandoUtil.updateExpando((long)this.contextCompany.getCompanyId(), CommercePricingClass.class, (long)commercePricingClass.getPrimaryKey(), (Map)customFields);
        }
        return this._updateNestedResources(productGroup, commercePricingClass);
    }
}

