/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPInstanceOptionValueRel;
import com.liferay.commerce.product.model.CPInstanceUnitOfMeasure;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalService;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelLocalService;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.product.util.CPInstanceHelper;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuOption;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.model.CPInstance"}, service={DTOConverter.class})
public class SkuDTOConverter
implements DTOConverter<CPInstance, Sku> {
    @Reference
    private CPDefinitionOptionRelLocalService _cpDefinitionOptionRelLocalService;
    @Reference
    private CPDefinitionOptionValueRelLocalService _cpDefinitionOptionValueRelLocalService;
    @Reference
    private CPInstanceHelper _cpInstanceHelper;
    @Reference
    private CPInstanceService _cpInstanceService;

    public String getContentType() {
        return Sku.class.getSimpleName();
    }

    public Sku toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPInstance cpInstance = this._cpInstanceService.getCPInstance(((Long)dtoConverterContext.getId()).longValue());
        final CPDefinition cpDefinition = cpInstance.getCPDefinition();
        final CPInstance replacementCPInstance = this._cpInstanceService.fetchCProductInstance(cpInstance.getReplacementCProductId(), cpInstance.getReplacementCPInstanceUuid());
        final CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure = (CPInstanceUnitOfMeasure)dtoConverterContext.getAttribute("cpInstanceUnitOfMeasure");
        return new Sku(){
            {
                this.cost = cpInstance.getCost();
                this.customFields = CustomFieldsUtil.toCustomFields(dtoConverterContext.isAcceptAllLanguages(), CPInstance.class.getName(), cpInstance.getCPInstanceId(), cpInstance.getCompanyId(), dtoConverterContext.getLocale());
                this.depth = cpInstance.getDepth();
                this.discontinued = cpInstance.isDiscontinued();
                this.discontinuedDate = cpInstance.getDiscontinuedDate();
                this.displayDate = cpInstance.getDisplayDate();
                this.expirationDate = cpInstance.getExpirationDate();
                this.externalReferenceCode = cpInstance.getExternalReferenceCode();
                this.gtin = cpInstance.getGtin();
                this.height = cpInstance.getHeight();
                this.id = cpInstance.getCPInstanceId();
                this.manufacturerPartNumber = cpInstance.getManufacturerPartNumber();
                this.price = cpInstance.getPrice();
                this.productId = cpDefinition.getCProductId();
                this.productName = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getNameMap());
                this.promoPrice = cpInstance.getPromoPrice();
                this.published = cpInstance.isPublished();
                this.purchasable = cpInstance.isPurchasable();
                this.sku = cpInstance.getSku();
                this.unspsc = cpInstance.getUnspsc();
                this.weight = cpInstance.getWeight();
                this.width = cpInstance.getWidth();
                this.setReplacementSkuExternalReferenceCode(() -> {
                    if (replacementCPInstance != null) {
                        return replacementCPInstance.getExternalReferenceCode();
                    }
                    return null;
                });
                this.setReplacementSkuId(() -> {
                    if (replacementCPInstance != null) {
                        return replacementCPInstance.getCPInstanceId();
                    }
                    return null;
                });
                this.setSkuOptions(() -> {
                    ArrayList<1> skuOptions = new ArrayList<1>();
                    List cpInstanceOptionValueRels = SkuDTOConverter.this._cpInstanceHelper.getCPInstanceCPInstanceOptionValueRels(cpInstance.getCPInstanceId());
                    for (CPInstanceOptionValueRel cpInstanceOptionValueRel : cpInstanceOptionValueRels) {
                        CPDefinitionOptionValueRel cpDefinitionOptionValueRel;
                        final CPDefinitionOptionRel cpDefinitionOptionRel = SkuDTOConverter.this._cpDefinitionOptionRelLocalService.fetchCPDefinitionOptionRel(cpInstanceOptionValueRel.getCPDefinitionOptionRelId());
                        if (cpDefinitionOptionRel == null || (cpDefinitionOptionValueRel = SkuDTOConverter.this._cpDefinitionOptionValueRelLocalService.fetchCPDefinitionOptionValueRel(cpInstanceOptionValueRel.getCPDefinitionOptionValueRelId())) == null) continue;
                        SkuOption skuOption = new SkuOption(){
                            {
                                this.key = cpDefinitionOptionRel.getKey();
                                this.optionId = cpDefinitionOptionRel.getCPDefinitionOptionRelId();
                                this.optionValueId = cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId();
                                this.value = cpDefinitionOptionValueRel.getKey();
                            }
                        };
                        skuOptions.add(skuOption);
                    }
                    return skuOptions.toArray(new SkuOption[0]);
                });
                this.setUnitOfMeasureKey(() -> {
                    if (cpInstanceUnitOfMeasure != null) {
                        return cpInstanceUnitOfMeasure.getKey();
                    }
                    return null;
                });
                this.setUnitOfMeasureName(() -> {
                    if (cpInstanceUnitOfMeasure != null) {
                        return LanguageUtils.getLanguageIdMap((Map)cpInstanceUnitOfMeasure.getNameMap());
                    }
                    return null;
                });
                this.setUnitOfMeasureSkuId(() -> {
                    if (cpInstanceUnitOfMeasure != null) {
                        return StringBundler.concat((Object[])new Object[]{cpInstance.getCPInstanceId(), "-", cpInstanceUnitOfMeasure.getCPInstanceUnitOfMeasureId()});
                    }
                    return String.valueOf(cpInstance.getCPInstanceId());
                });
            }
        };
    }
}

