/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductVirtualSettings;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductVirtualSettingsDTOConverter;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductVirtualSettingsResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductVirtualSettingsResource;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/product-virtual-settings.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={ProductVirtualSettingsResource.class})
public class ProductVirtualSettingsResourceImpl
extends BaseProductVirtualSettingsResourceImpl {
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private ProductVirtualSettingsDTOConverter _productVirtualSettingsDTOConverter;

    @Override
    public ProductVirtualSettings getProductByExternalReferenceCodeProductVirtualSettings(String externalReferenceCode) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._toProductVirtualSettings(cpDefinition.getCPDefinitionId());
    }

    @Override
    @NestedField(parentClass=Product.class, value="productVirtualSettings")
    public ProductVirtualSettings getProductIdProductVirtualSettings(@NestedFieldId(value="productId") Long id) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + id);
        }
        return this._toProductVirtualSettings(cpDefinition.getCPDefinitionId());
    }

    private ProductVirtualSettings _toProductVirtualSettings(Long cpDefinitionId) throws Exception {
        return this._productVirtualSettingsDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpDefinitionId, this.contextAcceptLanguage.getPreferredLocale()));
    }
}

