/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.service.CPDefinitionOptionRelService;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CPOptionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductOption;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductOptionResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductOptionUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductOptionResource;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/product-option.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={ProductOptionResource.class})
public class ProductOptionResourceImpl
extends BaseProductOptionResourceImpl {
    @Reference
    private CPDefinitionOptionRelService _cpDefinitionOptionRelService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPOptionService _cpOptionService;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductOptionDTOConverter)")
    private DTOConverter<CPDefinitionOptionRel, ProductOption> _productOptionDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteProductOption(Long id) throws Exception {
        CPDefinitionOptionRel cpDefinitionOptionRel = this._cpDefinitionOptionRelService.getCPDefinitionOptionRel(id.longValue());
        this._cpDefinitionOptionRelService.deleteCPDefinitionOptionRel(cpDefinitionOptionRel.getCPDefinitionOptionRelId());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Page<ProductOption> getProductByExternalReferenceCodeProductOptionsPage(String externalReferenceCode, String search, Pagination pagination, Sort[] sorts) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        BaseModelSearchResult cpDefinitionOptionRelBaseModelSearchResult = this._cpDefinitionOptionRelService.searchCPDefinitionOptionRels(cpDefinition.getCompanyId(), cpDefinition.getGroupId(), cpDefinition.getCPDefinitionId(), search, pagination.getStartPosition(), pagination.getEndPosition(), sorts);
        int totalItems = this._cpDefinitionOptionRelService.searchCPDefinitionOptionRelsCount(cpDefinition.getCompanyId(), cpDefinition.getGroupId(), cpDefinition.getCPDefinitionId(), search);
        return Page.of(this._toProductOptions(cpDefinitionOptionRelBaseModelSearchResult.getBaseModels()), (Pagination)pagination, (long)totalItems);
    }

    @Override
    @NestedField(parentClass=Product.class, value="productOptions")
    public Page<ProductOption> getProductIdProductOptionsPage(@NestedFieldId(value="productId") Long id, String search, Pagination pagination, Sort[] sorts) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        BaseModelSearchResult cpDefinitionOptionRelBaseModelSearchResult = this._cpDefinitionOptionRelService.searchCPDefinitionOptionRels(cpDefinition.getCompanyId(), cpDefinition.getGroupId(), cpDefinition.getCPDefinitionId(), search, pagination.getStartPosition(), pagination.getEndPosition(), sorts);
        int totalItems = this._cpDefinitionOptionRelService.searchCPDefinitionOptionRelsCount(cpDefinition.getCompanyId(), cpDefinition.getGroupId(), cpDefinition.getCPDefinitionId(), search);
        return Page.of(this._toProductOptions(cpDefinitionOptionRelBaseModelSearchResult.getBaseModels()), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public ProductOption getProductOption(Long id) throws Exception {
        return this._toProductOption(GetterUtil.getLong((Object)id));
    }

    @Override
    public Response patchProductOption(Long id, ProductOption productOption) throws Exception {
        this._updateProductOption(id, productOption);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Page<ProductOption> postProductByExternalReferenceCodeProductOptionsPage(String externalReferenceCode, ProductOption[] productOptions) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return Page.of(this._addOrUpdateProductOptions(cpDefinition, productOptions));
    }

    @Override
    public Page<ProductOption> postProductIdProductOptionsPage(Long id, ProductOption[] productOptions) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        return Page.of(this._addOrUpdateProductOptions(cpDefinition, productOptions));
    }

    private List<ProductOption> _addOrUpdateProductOptions(CPDefinition cpDefinition, ProductOption[] productOptions) throws Exception {
        for (ProductOption productOption : productOptions) {
            ProductOptionUtil.addOrUpdateCPDefinitionOptionRel(this._cpDefinitionOptionRelService, this._cpOptionService, productOption, cpDefinition.getCPDefinitionId(), this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId()));
        }
        ArrayList<ProductOption> productOptionList = new ArrayList<ProductOption>();
        cpDefinition = this._cpDefinitionService.getCPDefinition(cpDefinition.getCPDefinitionId());
        for (CPDefinitionOptionRel cpDefinitionOptionRel : cpDefinition.getCPDefinitionOptionRels()) {
            productOptionList.add(this._toProductOption(cpDefinitionOptionRel.getCPDefinitionOptionRelId()));
        }
        return productOptionList;
    }

    private ProductOption _toProductOption(Long cpDefinitionOptionRelId) throws Exception {
        return (ProductOption)this._productOptionDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpDefinitionOptionRelId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<ProductOption> _toProductOptions(List<CPDefinitionOptionRel> cpDefinitionOptionRels) throws Exception {
        ArrayList<ProductOption> productOptions = new ArrayList<ProductOption>();
        for (CPDefinitionOptionRel cpDefinitionOptionRel : cpDefinitionOptionRels) {
            productOptions.add(this._toProductOption(cpDefinitionOptionRel.getCPDefinitionOptionRelId()));
        }
        return productOptions;
    }

    private ProductOption _updateProductOption(long id, ProductOption productOption) throws Exception {
        CPDefinitionOptionRel cpDefinitionOptionRel = this._cpDefinitionOptionRelService.getCPDefinitionOptionRel(id);
        cpDefinitionOptionRel = this._cpDefinitionOptionRelService.updateCPDefinitionOptionRel(cpDefinitionOptionRel.getCPDefinitionOptionRelId(), productOption.getOptionId().longValue(), LanguageUtils.getLocalizedMap((Map)productOption.getName()), LanguageUtils.getLocalizedMap((Map)productOption.getDescription()), GetterUtil.get((String)productOption.getFieldType(), (String)cpDefinitionOptionRel.getCommerceOptionTypeKey()), GetterUtil.get((Object)productOption.getPriority(), (double)cpDefinitionOptionRel.getPriority()), GetterUtil.get((Object)productOption.getFacetable(), (boolean)cpDefinitionOptionRel.isFacetable()), GetterUtil.get((Object)productOption.getRequired(), (boolean)cpDefinitionOptionRel.isRequired()), GetterUtil.get((Object)productOption.getSkuContributor(), (boolean)cpDefinitionOptionRel.isSkuContributor()), this._serviceContextHelper.getServiceContext(cpDefinitionOptionRel.getGroupId()));
        return this._toProductOption(cpDefinitionOptionRel.getCPDefinitionOptionRelId());
    }
}

