/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.media.CommerceMediaResolver;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.product.type.virtual.model.CPDefinitionVirtualSetting;
import com.liferay.commerce.product.type.virtual.service.CPDefinitionVirtualSettingService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuVirtualSettings;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Status;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuVirtualSettings"}, service={DTOConverter.class})
public class SkuVirtualSettingsDTOConverter
implements DTOConverter<CPInstance, SkuVirtualSettings> {
    @Reference
    private CommerceMediaResolver _commerceMediaResolver;
    @Reference
    private CPDefinitionVirtualSettingService _cpDefinitionVirtualSettingService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private Language _language;

    public String getContentType() {
        return SkuVirtualSettings.class.getSimpleName();
    }

    public SkuVirtualSettings toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPInstance cpInstance = this._cpInstanceService.getCPInstance(((Long)dtoConverterContext.getId()).longValue());
        CPDefinition cpDefinition = cpInstance.getCPDefinition();
        if (!"virtual".equals(cpDefinition.getProductTypeName())) {
            return null;
        }
        final CPDefinitionVirtualSetting cpDefinitionVirtualSetting = this._cpDefinitionVirtualSettingService.fetchCPDefinitionVirtualSetting(CPInstance.class.getName(), cpInstance.getCPInstanceId());
        if (cpDefinitionVirtualSetting == null) {
            return null;
        }
        return new SkuVirtualSettings(){
            {
                this.activationStatus = cpDefinitionVirtualSetting.getActivationStatus();
                this.duration = TimeUnit.MILLISECONDS.toDays(cpDefinitionVirtualSetting.getDuration());
                this.maxUsages = cpDefinitionVirtualSetting.getMaxUsages();
                this.override = cpDefinitionVirtualSetting.isOverride();
                this.sampleURL = cpDefinitionVirtualSetting.getSampleURL();
                this.termsOfUseContent = LanguageUtils.getLanguageIdMap((Map)cpDefinitionVirtualSetting.getTermsOfUseContentMap());
                this.termsOfUseRequired = cpDefinitionVirtualSetting.isTermsOfUseRequired();
                this.url = cpDefinitionVirtualSetting.getUrl();
                this.useSample = cpDefinitionVirtualSetting.isUseSample();
                this.setActivationStatusInfo(() -> {
                    final String orderStatusLabel = CommerceOrderConstants.getOrderStatusLabel((int)cpDefinitionVirtualSetting.getActivationStatus());
                    return new Status(){
                        {
                            this.code = cpDefinitionVirtualSetting.getActivationStatus();
                            this.label = orderStatusLabel;
                            this.label_i18n = SkuVirtualSettingsDTOConverter.this._language.get(dtoConverterContext.getLocale(), orderStatusLabel);
                        }
                    };
                });
                this.setSampleSrc(() -> {
                    FileEntry fileEntry = cpDefinitionVirtualSetting.getSampleFileEntry();
                    if (fileEntry == null) {
                        return null;
                    }
                    return SkuVirtualSettingsDTOConverter.this._commerceMediaResolver.getDownloadVirtualProductSampleURL(CPInstance.class.getName(), cpInstance.getCPInstanceId(), Long.MIN_VALUE, fileEntry.getFileEntryId());
                });
                this.setSrc(() -> {
                    FileEntry fileEntry = cpDefinitionVirtualSetting.getFileEntry();
                    if (fileEntry == null) {
                        return null;
                    }
                    return SkuVirtualSettingsDTOConverter.this._commerceMediaResolver.getDownloadVirtualProductURL(CPInstance.class.getName(), cpInstance.getCPInstanceId(), Long.MIN_VALUE, fileEntry.getFileEntryId());
                });
                this.setTermsOfUseJournalArticleId(() -> {
                    JournalArticle journalArticle = cpDefinitionVirtualSetting.getTermsOfUseJournalArticle();
                    if (journalArticle == null) {
                        return null;
                    }
                    return journalArticle.getResourcePrimKey();
                });
            }
        };
    }
}

