/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.service.CPDefinitionInventoryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfiguration;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.math.BigDecimal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.model.CPDefinitionInventory"}, service={DTOConverter.class})
public class ProductConfigurationDTOConverter
implements DTOConverter<CPDefinitionInventory, ProductConfiguration> {
    @Reference
    private CPDefinitionInventoryService _cpDefinitionInventoryService;

    public String getContentType() {
        return ProductConfiguration.class.getSimpleName();
    }

    public ProductConfiguration toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryService.fetchCPDefinitionInventoryByCPDefinitionId(((Long)dtoConverterContext.getId()).longValue());
        if (cpDefinitionInventory == null) {
            return new ProductConfiguration();
        }
        return new ProductConfiguration(){
            {
                this.allowBackOrder = cpDefinitionInventory.isBackOrders();
                this.allowedOrderQuantities = cpDefinitionInventory.getAllowedOrderQuantitiesArray();
                this.inventoryEngine = cpDefinitionInventory.getCPDefinitionInventoryEngine();
                this.maxOrderQuantity = BigDecimalUtil.stripTrailingZeros((BigDecimal)cpDefinitionInventory.getMaxOrderQuantity());
                this.minOrderQuantity = BigDecimalUtil.stripTrailingZeros((BigDecimal)cpDefinitionInventory.getMinOrderQuantity());
                this.multipleOrderQuantity = BigDecimalUtil.stripTrailingZeros((BigDecimal)cpDefinitionInventory.getMultipleOrderQuantity());
            }
        };
    }
}

