/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.util;

import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.upload.UniqueFileNameProvider;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class FileEntryUtil {
    private static final String _TEMP_FILE_NAME = FileEntryUtil.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(FileEntryUtil.class);

    public static long getFileEntryId(String attachment, String url, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        if (Validator.isNotNull((String)attachment) && Validator.isNull((String)url)) {
            serviceContext.setExpandoBridgeAttributes(new HashMap());
            FileEntry fileEntry = FileEntryUtil._addFileEntry(FileUtil.createTempFile((byte[])Base64.decode((String)attachment)), null, uniqueFileNameProvider, serviceContext);
            return fileEntry.getFileEntryId();
        }
        return 0L;
    }

    private static FileEntry _addFileEntry(File file, String contentType, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        String uniqueFileName = uniqueFileNameProvider.provide(file.getName(), curFileName -> FileEntryUtil._exists(serviceContext.getScopeGroupId(), serviceContext.getUserId(), curFileName));
        if (Validator.isNull((String)contentType)) {
            contentType = MimeTypesUtil.getContentType((File)file);
        }
        uniqueFileName = FileEntryUtil._appendExtension(contentType, uniqueFileName);
        FileEntry fileEntry = DLAppServiceUtil.addFileEntry(null, (long)serviceContext.getScopeGroupId(), (long)0L, (String)uniqueFileName, (String)contentType, (String)uniqueFileName, (String)"", null, (String)"", (File)file, null, null, (ServiceContext)serviceContext);
        FileUtil.delete((File)file);
        return fileEntry;
    }

    private static String _appendExtension(String contentType, String uniqueFileName) {
        Iterator iterator;
        String extension = "";
        Set extensions = MimeTypesUtil.getExtensions((String)contentType);
        if (!extensions.isEmpty() && (iterator = extensions.iterator()).hasNext()) {
            extension = (String)iterator.next();
        }
        return uniqueFileName.concat(extension);
    }

    private static boolean _exists(long groupId, long userId, String curFileName) {
        try {
            FileEntry fileEntry = TempFileEntryUtil.getTempFileEntry((long)groupId, (long)userId, (String)_TEMP_FILE_NAME, (String)curFileName);
            return fileEntry != null;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return false;
        }
    }
}

