/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPAttachmentFileEntryService;
import com.liferay.commerce.product.service.CPDefinitionOptionRelService;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelService;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CPOptionService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Attachment;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.AttachmentBase64;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.AttachmentUrl;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseAttachmentResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.AttachmentUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.AttachmentResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.upload.UniqueFileNameProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/attachment.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={AttachmentResource.class})
public class AttachmentResourceImpl
extends BaseAttachmentResourceImpl {
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.AttachmentDTOConverter)")
    private DTOConverter<CPAttachmentFileEntry, Attachment> _attachmentDTOConverter;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CPAttachmentFileEntryService _cpAttachmentFileEntryService;
    @Reference
    private CPDefinitionOptionRelService _cpDefinitionOptionRelService;
    @Reference
    private CPDefinitionOptionValueRelService _cpDefinitionOptionValueRelService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPOptionService _cpOptionService;
    @Reference(target="(model.class.name=com.liferay.document.library.kernel.model.DLFileEntry)")
    private ModelResourcePermission<DLFileEntry> _dlFileEntryModelResourcePermission;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private UniqueFileNameProvider _uniqueFileNameProvider;

    @Override
    public Page<Attachment> getProductByExternalReferenceCodeAttachmentsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._getAttachmentPage(cpDefinition, 1, pagination);
    }

    @Override
    public Page<Attachment> getProductByExternalReferenceCodeImagesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._getAttachmentPage(cpDefinition, 0, pagination);
    }

    @Override
    @NestedField(parentClass=Product.class, value="attachments")
    public Page<Attachment> getProductIdAttachmentsPage(@NestedFieldId(value="productId") Long id, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        return this._getAttachmentPage(cpDefinition, 1, pagination);
    }

    @Override
    @NestedField(parentClass=Product.class, value="images")
    public Page<Attachment> getProductIdImagesPage(@NestedFieldId(value="productId") Long id, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        return this._getAttachmentPage(cpDefinition, 0, pagination);
    }

    @Override
    public Attachment postProductByExternalReferenceCodeAttachment(String externalReferenceCode, Attachment attachment) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._addOrUpdateProductAttachment(cpDefinition, attachment);
    }

    @Override
    public Attachment postProductByExternalReferenceCodeAttachmentByBase64(String externalReferenceCode, AttachmentBase64 attachmentBase64) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._addOrUpdateProductAttachment(cpDefinition, attachmentBase64);
    }

    @Override
    public Attachment postProductByExternalReferenceCodeAttachmentByUrl(String externalReferenceCode, AttachmentUrl attachmentUrl) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._addOrUpdateProductAttachment(cpDefinition, attachmentUrl);
    }

    @Override
    public Attachment postProductByExternalReferenceCodeImage(String externalReferenceCode, Attachment attachment) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._addOrUpdateProductImage(cpDefinition, attachment);
    }

    @Override
    public Attachment postProductByExternalReferenceCodeImageByBase64(String externalReferenceCode, AttachmentBase64 attachmentBase64) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._addOrUpdateProductImage(cpDefinition, attachmentBase64);
    }

    @Override
    public Attachment postProductByExternalReferenceCodeImageByUrl(String externalReferenceCode, AttachmentUrl attachmentUrl) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._addOrUpdateProductImage(cpDefinition, attachmentUrl);
    }

    @Override
    public Attachment postProductIdAttachment(Long id, Attachment attachment) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        return this._addOrUpdateProductAttachment(cpDefinition, attachment);
    }

    @Override
    public Attachment postProductIdAttachmentByBase64(Long id, AttachmentBase64 attachmentBase64) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        return this._addOrUpdateProductAttachment(cpDefinition, attachmentBase64);
    }

    @Override
    public Attachment postProductIdAttachmentByUrl(Long id, AttachmentUrl attachmentUrl) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        return this._addOrUpdateProductAttachment(cpDefinition, attachmentUrl);
    }

    @Override
    public Attachment postProductIdImage(Long id, Attachment attachment) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        return this._addOrUpdateProductImage(cpDefinition, attachment);
    }

    @Override
    public Attachment postProductIdImageByBase64(Long id, AttachmentBase64 attachmentBase64) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        return this._addOrUpdateProductImage(cpDefinition, attachmentBase64);
    }

    @Override
    public Attachment postProductIdImageByUrl(Long id, AttachmentUrl attachmentUrl) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        return this._addOrUpdateProductImage(cpDefinition, attachmentUrl);
    }

    @Override
    public Page<Attachment> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return Page.of(Collections.emptyList());
    }

    private Attachment _addOrUpdateAttachment(CPDefinition cpDefinition, int type, Attachment attachment) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId());
        Map<String, Serializable> expandoBridgeAttributes = CustomFieldsUtil.toMap(CPAttachmentFileEntry.class.getName(), this.contextCompany.getCompanyId(), attachment.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
        if (expandoBridgeAttributes != null) {
            serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
        }
        CPAttachmentFileEntry cpAttachmentFileEntry = AttachmentUtil.addOrUpdateCPAttachmentFileEntry(cpDefinition.getGroupId(), this._cpAttachmentFileEntryService, this._cpDefinitionOptionRelService, this._cpDefinitionOptionValueRelService, this._cpOptionService, this._dlFileEntryModelResourcePermission, this._uniqueFileNameProvider, attachment, this._classNameLocalService.getClassNameId(cpDefinition.getModelClassName()), cpDefinition.getCPDefinitionId(), type, serviceContext);
        return this._toAttachment(cpAttachmentFileEntry.getCPAttachmentFileEntryId());
    }

    private Attachment _addOrUpdateAttachment(CPDefinition cpDefinition, int type, AttachmentBase64 attachmentBase64) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId());
        Map<String, Serializable> expandoBridgeAttributes = CustomFieldsUtil.toMap(CPAttachmentFileEntry.class.getName(), this.contextCompany.getCompanyId(), attachmentBase64.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
        if (expandoBridgeAttributes != null) {
            serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
        }
        CPAttachmentFileEntry cpAttachmentFileEntry = AttachmentUtil.addOrUpdateCPAttachmentFileEntry(this._cpAttachmentFileEntryService, this._cpDefinitionOptionRelService, this._cpDefinitionOptionValueRelService, this._cpOptionService, this._uniqueFileNameProvider, attachmentBase64, this._classNameLocalService.getClassNameId(cpDefinition.getModelClassName()), cpDefinition.getCPDefinitionId(), type, serviceContext);
        return this._toAttachment(cpAttachmentFileEntry.getCPAttachmentFileEntryId());
    }

    private Attachment _addOrUpdateAttachment(CPDefinition cpDefinition, int type, AttachmentUrl attachmentUrl) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId());
        Map<String, Serializable> expandoBridgeAttributes = CustomFieldsUtil.toMap(CPAttachmentFileEntry.class.getName(), this.contextCompany.getCompanyId(), attachmentUrl.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
        if (expandoBridgeAttributes != null) {
            serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
        }
        CPAttachmentFileEntry cpAttachmentFileEntry = AttachmentUtil.addOrUpdateCPAttachmentFileEntry(this._cpAttachmentFileEntryService, this._cpDefinitionOptionRelService, this._cpDefinitionOptionValueRelService, this._cpOptionService, this._uniqueFileNameProvider, attachmentUrl, this._classNameLocalService.getClassNameId(cpDefinition.getModelClassName()), cpDefinition.getCPDefinitionId(), type, serviceContext);
        return this._toAttachment(cpAttachmentFileEntry.getCPAttachmentFileEntryId());
    }

    private Attachment _addOrUpdateProductAttachment(CPDefinition cpDefinition, Attachment attachment) throws Exception {
        return this._addOrUpdateAttachment(cpDefinition, 1, attachment);
    }

    private Attachment _addOrUpdateProductAttachment(CPDefinition cpDefinition, AttachmentBase64 attachment) throws Exception {
        return this._addOrUpdateAttachment(cpDefinition, 1, attachment);
    }

    private Attachment _addOrUpdateProductAttachment(CPDefinition cpDefinition, AttachmentUrl attachment) throws Exception {
        return this._addOrUpdateAttachment(cpDefinition, 1, attachment);
    }

    private Attachment _addOrUpdateProductImage(CPDefinition cpDefinition, Attachment attachment) throws Exception {
        return this._addOrUpdateAttachment(cpDefinition, 0, attachment);
    }

    private Attachment _addOrUpdateProductImage(CPDefinition cpDefinition, AttachmentBase64 attachment) throws Exception {
        return this._addOrUpdateAttachment(cpDefinition, 0, attachment);
    }

    private Attachment _addOrUpdateProductImage(CPDefinition cpDefinition, AttachmentUrl attachment) throws Exception {
        return this._addOrUpdateAttachment(cpDefinition, 0, attachment);
    }

    private Page<Attachment> _getAttachmentPage(CPDefinition cpDefinition, int type, Pagination pagination) throws Exception {
        List cpAttachmentFileEntries = this._cpAttachmentFileEntryService.getCPAttachmentFileEntries(this._classNameLocalService.getClassNameId(cpDefinition.getModelClass()), cpDefinition.getCPDefinitionId(), type, 0, pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._cpAttachmentFileEntryService.getCPAttachmentFileEntriesCount(this._classNameLocalService.getClassNameId(cpDefinition.getModelClass()), cpDefinition.getCPDefinitionId(), type, 0);
        return Page.of(this._toAttachments(cpAttachmentFileEntries), (Pagination)pagination, (long)totalItems);
    }

    private Attachment _toAttachment(Long cpAttachmentFileEntryId) throws Exception {
        return (Attachment)this._attachmentDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpAttachmentFileEntryId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<Attachment> _toAttachments(List<CPAttachmentFileEntry> cpAttachmentFileEntries) throws Exception {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        for (CPAttachmentFileEntry cpAttachmentFileEntry : cpAttachmentFileEntries) {
            attachments.add(this._toAttachment(cpAttachmentFileEntry.getCPAttachmentFileEntryId()));
        }
        return attachments;
    }
}

