/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.util.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionLink;
import com.liferay.commerce.product.service.CPDefinitionLinkService;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.RelatedProduct;
import com.liferay.headless.commerce.admin.catalog.internal.util.DateConfigUtil;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Calendar;
import java.util.TimeZone;

public class RelatedProductUtil {
    public static CPDefinitionLink addOrUpdateCPDefinitionLink(CPDefinitionLinkService cpDefinitionLinkService, CPDefinitionService cpDefinitionService, RelatedProduct relatedProduct, long cpDefinitionId, ServiceContext serviceContext) throws PortalException {
        CPDefinition cpDefinition = null;
        if (Validator.isNotNull((String)relatedProduct.getProductExternalReferenceCode())) {
            cpDefinition = cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(relatedProduct.getProductExternalReferenceCode(), serviceContext.getCompanyId());
            if (cpDefinition == null) {
                throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + relatedProduct.getProductExternalReferenceCode());
            }
        } else {
            cpDefinition = cpDefinitionService.fetchCPDefinitionByCProductId(relatedProduct.getProductId().longValue());
            if (cpDefinition == null) {
                throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + relatedProduct.getProductId());
            }
        }
        CPDefinitionLink cpDefinitionLink = cpDefinitionLinkService.fetchCPDefinitionLink(cpDefinitionId, cpDefinition.getCProductId(), relatedProduct.getType());
        if (relatedProduct.getId() != null) {
            cpDefinitionLink = cpDefinitionLinkService.fetchCPDefinitionLink(relatedProduct.getId().longValue());
        }
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        DateConfig displayDateConfig = new DateConfig(displayCalendar);
        if (cpDefinitionLink == null) {
            return cpDefinitionLinkService.addCPDefinitionLink(cpDefinitionId, cpDefinition.getCProductId(), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), 0, 0, 0, 0, 0, true, GetterUtil.get((Object)relatedProduct.getPriority(), (double)0.0), relatedProduct.getType(), serviceContext);
        }
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        boolean neverExpire = true;
        if (cpDefinitionLink.getExpirationDate() != null) {
            expirationCalendar = DateConfigUtil.convertDateToCalendar(cpDefinitionLink.getExpirationDate());
            neverExpire = false;
        }
        DateConfig expirationDateConfig = new DateConfig(expirationCalendar);
        return cpDefinitionLinkService.updateCPDefinitionLink(cpDefinitionLink.getCPDefinitionLinkId(), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), neverExpire, GetterUtil.get((Object)relatedProduct.getPriority(), (double)cpDefinitionLink.getPriority()), serviceContext);
    }
}

