/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.price.list.exception.CommercePriceEntryPriceException;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.service.CommercePriceEntryService;
import com.liferay.commerce.product.exception.NoSuchCPInstanceException;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPInstanceUnitOfMeasure;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.product.service.CPInstanceUnitOfMeasureService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuUnitOfMeasure;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseSkuUnitOfMeasureResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.SkuUnitOfMeasureResource;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/sku-unit-of-measure.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={SkuUnitOfMeasureResource.class})
public class SkuUnitOfMeasureResourceImpl
extends BaseSkuUnitOfMeasureResourceImpl {
    @Reference
    private CommercePriceEntryService _commercePriceEntryService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private CPInstanceUnitOfMeasureService _cpInstanceUnitOfMeasureService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.SkuUnitOfMeasureDTOConverter)")
    private DTOConverter<CPInstanceUnitOfMeasure, SkuUnitOfMeasure> _skuUnitOfMeasureDTOConverter;

    @Override
    public void deleteSkuUnitOfMeasure(Long id) throws Exception {
        this._cpInstanceUnitOfMeasureService.deleteCPInstanceUnitOfMeasure(id.longValue());
    }

    @Override
    public Page<SkuUnitOfMeasure> getSkuByExternalReferenceCodeSkuUnitOfMeasuresPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CPInstance cpInstance = this._cpInstanceService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpInstance == null) {
            throw new NoSuchCPInstanceException("Unable to find SKU with external reference code " + externalReferenceCode);
        }
        return Page.of(this.transform(this._cpInstanceUnitOfMeasureService.getCPInstanceUnitOfMeasures(cpInstance.getCPInstanceId(), pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toSkuUnitOfMeasure), (Pagination)pagination, (long)this._cpInstanceUnitOfMeasureService.getCPInstanceUnitOfMeasuresCount(cpInstance.getCPInstanceId()));
    }

    @Override
    @NestedField(parentClass=Sku.class, value="skuUnitOfMeasures")
    public Page<SkuUnitOfMeasure> getSkuIdSkuUnitOfMeasuresPage(Long id, Pagination pagination) throws Exception {
        return Page.of(this.transform(this._cpInstanceUnitOfMeasureService.getCPInstanceUnitOfMeasures(id.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toSkuUnitOfMeasure), (Pagination)pagination, (long)this._cpInstanceUnitOfMeasureService.getCPInstanceUnitOfMeasuresCount(id.longValue()));
    }

    @Override
    public SkuUnitOfMeasure getSkuUnitOfMeasure(Long id) throws Exception {
        return this._toSkuUnitOfMeasure(this._cpInstanceUnitOfMeasureService.getCPInstanceUnitOfMeasure(id.longValue()));
    }

    @Override
    public SkuUnitOfMeasure patchSkuUnitOfMeasure(Long id, SkuUnitOfMeasure skuUnitOfMeasure) throws Exception {
        CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure = this._cpInstanceUnitOfMeasureService.getCPInstanceUnitOfMeasure(id.longValue());
        Map nameMap = skuUnitOfMeasure.getName();
        if (nameMap == null || nameMap.isEmpty()) {
            nameMap = LanguageUtils.getLanguageIdMap((Map)cpInstanceUnitOfMeasure.getNameMap());
        }
        cpInstanceUnitOfMeasure = this._cpInstanceUnitOfMeasureService.updateCPInstanceUnitOfMeasure(id.longValue(), cpInstanceUnitOfMeasure.getCPInstanceId(), GetterUtil.get((Object)skuUnitOfMeasure.getActive(), (boolean)cpInstanceUnitOfMeasure.isActive()), (BigDecimal)GetterUtil.get((Object)skuUnitOfMeasure.getIncrementalOrderQuantity(), (Number)cpInstanceUnitOfMeasure.getIncrementalOrderQuantity()), cpInstanceUnitOfMeasure.getKey(), LanguageUtils.getLocalizedMap((Map)nameMap), GetterUtil.get((Object)skuUnitOfMeasure.getPrecision(), (int)cpInstanceUnitOfMeasure.getPrecision()), GetterUtil.get((Object)skuUnitOfMeasure.getPrimary(), (boolean)cpInstanceUnitOfMeasure.isPrimary()), GetterUtil.get((Object)skuUnitOfMeasure.getPriority(), (double)cpInstanceUnitOfMeasure.getPriority()), (BigDecimal)GetterUtil.get((Object)skuUnitOfMeasure.getRate(), (Number)cpInstanceUnitOfMeasure.getRate()), cpInstanceUnitOfMeasure.getSku());
        if (skuUnitOfMeasure.getBasePrice() != null || skuUnitOfMeasure.getPromoPrice() != null) {
            CPInstance cpInstance = this._cpInstanceService.getCPInstance(cpInstanceUnitOfMeasure.getCPInstanceId());
            if (skuUnitOfMeasure.getBasePrice() != null) {
                this._updateCommercePriceEntry(cpInstance, cpInstanceUnitOfMeasure, skuUnitOfMeasure.getBasePrice(), "price-list");
            }
            if (skuUnitOfMeasure.getPromoPrice() != null) {
                this._updateCommercePriceEntry(cpInstance, cpInstanceUnitOfMeasure, skuUnitOfMeasure.getPromoPrice(), "promotion");
            }
        }
        return this._toSkuUnitOfMeasure(cpInstanceUnitOfMeasure);
    }

    @Override
    public SkuUnitOfMeasure postSkuByExternalReferenceCodeSkuUnitOfMeasure(String externalReferenceCode, SkuUnitOfMeasure skuUnitOfMeasure) throws Exception {
        CPInstance cpInstance = this._cpInstanceService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpInstance == null) {
            throw new NoSuchCPInstanceException("Unable to find SKU with external reference code " + externalReferenceCode);
        }
        return this._toSkuUnitOfMeasure(this._addOrUpdateCPInstanceUnitOfMeasure(cpInstance, skuUnitOfMeasure));
    }

    @Override
    public SkuUnitOfMeasure postSkuIdSkuUnitOfMeasure(Long id, SkuUnitOfMeasure skuUnitOfMeasure) throws Exception {
        return this._toSkuUnitOfMeasure(this._addOrUpdateCPInstanceUnitOfMeasure(this._cpInstanceService.getCPInstance(id.longValue()), skuUnitOfMeasure));
    }

    private CPInstanceUnitOfMeasure _addOrUpdateCPInstanceUnitOfMeasure(CPInstance cpInstance, SkuUnitOfMeasure skuUnitOfMeasure) throws Exception {
        CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure = this._cpInstanceUnitOfMeasureService.addOrUpdateCPInstanceUnitOfMeasure(cpInstance.getCPInstanceId(), GetterUtil.get((Object)skuUnitOfMeasure.getActive(), (boolean)true), (BigDecimal)GetterUtil.getNumber((Object)skuUnitOfMeasure.getIncrementalOrderQuantity(), (Number)BigDecimal.ONE), skuUnitOfMeasure.getKey(), LanguageUtils.getLocalizedMap((Map)skuUnitOfMeasure.getName()), GetterUtil.getInteger((Object)skuUnitOfMeasure.getPrecision()), GetterUtil.get((Object)skuUnitOfMeasure.getPrimary(), (boolean)this._isDefaultPrimary(cpInstance.getCPInstanceId())), GetterUtil.getDouble((Object)skuUnitOfMeasure.getPriority()), (BigDecimal)GetterUtil.getNumber((Object)skuUnitOfMeasure.getRate(), (Number)BigDecimal.ONE), cpInstance.getSku());
        int count = this._cpInstanceUnitOfMeasureService.getCPInstanceUnitOfMeasuresCount(cpInstance.getCPInstanceId());
        if (count > 1 && skuUnitOfMeasure.getBasePrice() == null) {
            throw new CommercePriceEntryPriceException();
        }
        if (skuUnitOfMeasure.getBasePrice() != null) {
            this._updateCommercePriceEntry(cpInstance, cpInstanceUnitOfMeasure, skuUnitOfMeasure.getBasePrice(), "price-list");
        }
        if (skuUnitOfMeasure.getPromoPrice() != null) {
            this._updateCommercePriceEntry(cpInstance, cpInstanceUnitOfMeasure, skuUnitOfMeasure.getPromoPrice(), "promotion");
        }
        return cpInstanceUnitOfMeasure;
    }

    private boolean _isDefaultPrimary(long cpInstanceId) throws Exception {
        int count = this._cpInstanceUnitOfMeasureService.getCPInstanceUnitOfMeasuresCount(cpInstanceId);
        return count <= 0;
    }

    private SkuUnitOfMeasure _toSkuUnitOfMeasure(CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure) throws Exception {
        return (SkuUnitOfMeasure)this._skuUnitOfMeasureDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), new HashMap(), null, (Object)cpInstanceUnitOfMeasure.getCPInstanceUnitOfMeasureId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private void _updateCommercePriceEntry(CPInstance cpInstance, CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure, BigDecimal price, String type) throws Exception {
        if (price == null) {
            return;
        }
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryService.getInstanceBaseCommercePriceEntry(cpInstance.getCPInstanceUuid(), type, cpInstanceUnitOfMeasure.getKey());
        if (commercePriceEntry != null) {
            this._commercePriceEntryService.updateCommercePriceEntry(commercePriceEntry.getCommercePriceEntryId(), price, commercePriceEntry.isPriceOnApplication(), commercePriceEntry.getPromoPrice(), cpInstanceUnitOfMeasure.getKey(), this._serviceContextHelper.getServiceContext());
        }
    }
}

