/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.shop.by.diagram.model.CSDiagramSetting;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramSettingService;
import com.liferay.document.library.util.DLURLHelperUtil;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Diagram;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.shop.by.diagram.model.CSDiagramSetting"}, service={DTOConverter.class})
public class DiagramDTOConverter
implements DTOConverter<CSDiagramSetting, Diagram> {
    @Reference
    private CSDiagramSettingService _csDiagramSettingService;

    public String getContentType() {
        return Diagram.class.getSimpleName();
    }

    public Diagram toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CSDiagramSetting csDiagramSetting = this._csDiagramSettingService.getCSDiagramSetting(((Long)dtoConverterContext.getId()).longValue());
        CPDefinition cpDefinition = csDiagramSetting.getCPDefinition();
        final CProduct cProduct = cpDefinition.getCProduct();
        return new Diagram(){
            {
                this.color = csDiagramSetting.getColor();
                this.id = csDiagramSetting.getCSDiagramSettingId();
                this.productExternalReferenceCode = cProduct.getExternalReferenceCode();
                this.productId = cProduct.getCProductId();
                this.radius = csDiagramSetting.getRadius();
                this.type = csDiagramSetting.getType();
                this.setImageURL(() -> {
                    CPAttachmentFileEntry cpAttachmentFileEntry = csDiagramSetting.getCPAttachmentFileEntry();
                    FileEntry fileEntry = cpAttachmentFileEntry.fetchFileEntry();
                    if (fileEntry == null) {
                        return null;
                    }
                    return DLURLHelperUtil.getDownloadURL((FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), null, null);
                });
            }
        };
    }
}

