/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuSubscriptionConfiguration;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=SkuSubscriptionConfiguration"}, service={DTOConverter.class, SkuSubscriptionConfigurationDTOConverter.class})
public class SkuSubscriptionConfigurationDTOConverter
implements DTOConverter<CPInstance, SkuSubscriptionConfiguration> {
    @Reference
    private CPInstanceService _cpInstanceService;

    public String getContentType() {
        return SkuSubscriptionConfiguration.class.getSimpleName();
    }

    public SkuSubscriptionConfiguration toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CPInstance cpInstance = this._cpInstanceService.getCPInstance(((Long)dtoConverterContext.getId()).longValue());
        return new SkuSubscriptionConfiguration(){
            {
                this.deliverySubscriptionEnable = cpInstance.isDeliverySubscriptionEnabled();
                this.deliverySubscriptionLength = cpInstance.getDeliverySubscriptionLength();
                this.deliverySubscriptionNumberOfLength = cpInstance.getDeliveryMaxSubscriptionCycles();
                this.deliverySubscriptionType = SkuSubscriptionConfiguration.DeliverySubscriptionType.create((String)cpInstance.getDeliverySubscriptionType());
                this.deliverySubscriptionTypeSettings = cpInstance.getDeliverySubscriptionTypeSettingsUnicodeProperties();
                this.enable = cpInstance.isSubscriptionEnabled();
                this.length = cpInstance.getSubscriptionLength();
                this.numberOfLength = cpInstance.getMaxSubscriptionCycles();
                this.overrideSubscriptionInfo = cpInstance.isOverrideSubscriptionInfo();
                this.subscriptionType = SkuSubscriptionConfiguration.SubscriptionType.create((String)cpInstance.getSubscriptionType());
                this.subscriptionTypeSettings = cpInstance.getSubscriptionTypeSettingsUnicodeProperties();
            }
        };
    }
}

