/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPOptionCategory;
import com.liferay.commerce.product.service.CPOptionCategoryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.OptionCategory;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Alessio Antonio Rendina
 */
@Component(
	enabled = false,
	property = "model.class.name=com.liferay.commerce.product.model.CPOptionCategory",
	service = {DTOConverter.class, OptionCategoryDTOConverter.class}
)
public class OptionCategoryDTOConverter
	implements DTOConverter<CPOptionCategory, OptionCategory> {

	@Override
	public String getContentType() {
		return OptionCategory.class.getSimpleName();
	}

	@Override
	public OptionCategory toDTO(DTOConverterContext dtoConverterContext)
		throws Exception {

		CPOptionCategory cpOptionCategory =
			_cpOptionCategoryService.getCPOptionCategory(
				(Long)dtoConverterContext.getId());

		return new OptionCategory() {
			{
				description = LanguageUtils.getLanguageIdMap(
					cpOptionCategory.getDescriptionMap());
				id = cpOptionCategory.getCPOptionCategoryId();
				key = cpOptionCategory.getKey();
				priority = cpOptionCategory.getPriority();
				title = LanguageUtils.getLanguageIdMap(
					cpOptionCategory.getTitleMap());
			}
		};
	}

	@Reference
	private CPOptionCategoryService _cpOptionCategoryService;

}