/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.helper.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionSpecificationOptionValue;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CPDefinitionSpecificationOptionValueService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductSpecification;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductSpecificationDTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={ProductSpecificationHelper.class})
public class ProductSpecificationHelper {
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPDefinitionSpecificationOptionValueService _cpDefinitionSpecificationOptionValueService;
    @Reference
    private ProductSpecificationDTOConverter _productSpecificationDTOConverter;

    public Page<ProductSpecification> getProductSpecificationsPage(long productId, Locale locale, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(productId);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + productId);
        }
        List cpDefinitionSpecificationOptionValues = this._cpDefinitionSpecificationOptionValueService.getCPDefinitionSpecificationOptionValues(cpDefinition.getCPDefinitionId(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._cpDefinitionSpecificationOptionValueService.getCPDefinitionSpecificationOptionValuesCount(cpDefinition.getCPDefinitionId());
        return Page.of(this.toProductSpecifications(cpDefinitionSpecificationOptionValues, locale), (Pagination)pagination, (long)totalItems);
    }

    public List<ProductSpecification> toProductSpecifications(List<CPDefinitionSpecificationOptionValue> cpDefinitionSpecificationOptionValues, Locale locale) throws Exception {
        ArrayList<ProductSpecification> productSpecifications = new ArrayList<ProductSpecification>();
        for (CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue : cpDefinitionSpecificationOptionValues) {
            productSpecifications.add(this._productSpecificationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId(), locale)));
        }
        return productSpecifications;
    }
}

