/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.helper.v1_0;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryService;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Category;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.CategoryDTOConverter;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CategoryHelper.class})
public class CategoryHelper {
    @Reference
    private AssetCategoryService _assetCategoryService;
    @Reference
    private CategoryDTOConverter _categoryDTOConverter;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CPDefinitionService _cpDefinitionService;

    public Page<Category> getCategoriesPage(long id, Locale locale, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        List assetCategories = this._assetCategoryService.getCategories(this._classNameLocalService.getClassNameId(cpDefinition.getModelClass()), cpDefinition.getCPDefinitionId(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._assetCategoryService.getCategoriesCount(this._classNameLocalService.getClassNameId(cpDefinition.getModelClass()), cpDefinition.getCPDefinitionId());
        return Page.of(this.toProductCategories(assetCategories, locale), (Pagination)pagination, (long)totalItems);
    }

    public List<Category> toProductCategories(List<AssetCategory> assetCategories, Locale locale) throws Exception {
        ArrayList<Category> categories = new ArrayList<Category>();
        for (AssetCategory category : assetCategories) {
            categories.add(this._categoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)category.getCategoryId(), locale)));
        }
        return categories;
    }
}

