/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.commerce.pricing.model.CommercePricingClassCPDefinitionRel;
import com.liferay.commerce.pricing.service.CommercePricingClassCPDefinitionRelService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductGroupProduct;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.pricing.model.CommercePricingClassCPDefinitionRel"}, service={DTOConverter.class, ProductGroupProductDTOConverter.class})
public class ProductGroupProductDTOConverter
implements DTOConverter<CommercePricingClassCPDefinitionRel, ProductGroupProduct> {
    @Reference
    private CommercePricingClassCPDefinitionRelService _commercePricingClassCPDefinitionRelService;
    @Reference
    private CPDefinitionService _cpDefinitionService;

    public String getContentType() {
        return ProductGroupProduct.class.getSimpleName();
    }

    public ProductGroupProduct toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CommercePricingClassCPDefinitionRel commercePricingClassCPDefinitionRel = this._commercePricingClassCPDefinitionRelService.getCommercePricingClassCPDefinitionRel(((Long)dtoConverterContext.getId()).longValue());
        final CPDefinition cpDefinition = this._cpDefinitionService.getCPDefinition(commercePricingClassCPDefinitionRel.getCPDefinitionId());
        final CProduct cProduct = cpDefinition.getCProduct();
        final CommercePricingClass commercePricingClass = commercePricingClassCPDefinitionRel.getCommercePricingClass();
        final Locale locale = dtoConverterContext.getLocale();
        final String languageId = LanguageUtil.getLanguageId((Locale)locale);
        return new ProductGroupProduct(){
            {
                this.id = commercePricingClassCPDefinitionRel.getCommercePricingClassCPDefinitionRelId();
                this.productExternalReferenceCode = cProduct.getExternalReferenceCode();
                this.productGroupExternalReferenceCode = commercePricingClass.getExternalReferenceCode();
                this.productGroupId = commercePricingClass.getCommercePricingClassId();
                this.productId = cProduct.getCProductId();
                this.productName = cpDefinition.getName(languageId);
                this.sku = ProductGroupProductDTOConverter.this._getSku(cpDefinition, locale);
            }
        };
    }

    private String _getSku(CPDefinition cpDefinition, Locale locale) {
        List cpInstances = cpDefinition.getCPInstances();
        if (cpInstances.isEmpty()) {
            return "";
        }
        if (cpInstances.size() > 1) {
            return LanguageUtil.get((Locale)locale, (String)"multiple-skus");
        }
        CPInstance cpInstance = (CPInstance)cpInstances.get(0);
        return cpInstance.getSku();
    }
}

