/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.headless.commerce.admin.catalog.internal.util.v1_0;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductTaxConfiguration;
import com.liferay.portal.kernel.exception.PortalException;

/**
 * @author Alessio Antonio Rendina
 */
public class ProductTaxConfigurationUtil {

	public static CPDefinition updateCPDefinitionTaxCategoryInfo(
			CPDefinitionService cpDefinitionService,
			ProductTaxConfiguration productTaxConfiguration,
			CPDefinition cpDefinition)
		throws PortalException {

		return cpDefinitionService.updateTaxCategoryInfo(
			cpDefinition.getCPDefinitionId(), productTaxConfiguration.getId(),
			ProductUtil.isTaxExempt(cpDefinition, productTaxConfiguration),
			false);
	}

}