/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductShippingConfiguration;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;

import java.math.BigDecimal;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Alessio Antonio Rendina
 */
@Component(
	property = "model.class.name=ProductShippingConfiguration",
	service = {
		DTOConverter.class, ProductShippingConfigurationDTOConverter.class
	}
)
public class ProductShippingConfigurationDTOConverter
	implements DTOConverter<CPDefinition, ProductShippingConfiguration> {

	@Override
	public String getContentType() {
		return ProductShippingConfiguration.class.getSimpleName();
	}

	public ProductShippingConfiguration toDTO(
			DTOConverterContext dtoConverterContext)
		throws Exception {

		CPDefinition cpDefinition = _cpDefinitionService.getCPDefinition(
			(Long)dtoConverterContext.getId());

		return new ProductShippingConfiguration() {
			{
				depth = BigDecimal.valueOf(cpDefinition.getDepth());
				freeShipping = cpDefinition.isFreeShipping();
				height = BigDecimal.valueOf(cpDefinition.getHeight());
				shippable = cpDefinition.isShippable();
				shippingExtraPrice = BigDecimal.valueOf(
					cpDefinition.getShippingExtraPrice());
				shippingSeparately = cpDefinition.isShipSeparately();
				weight = BigDecimal.valueOf(cpDefinition.getWeight());
				width = BigDecimal.valueOf(cpDefinition.getWidth());
			}
		};
	}

	@Reference
	private CPDefinitionService _cpDefinitionService;

}