/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.media.CommerceMediaResolver;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.service.CPAttachmentFileEntryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Attachment;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.product.model.CPAttachmentFileEntry"}, service={AttachmentDTOConverter.class, DTOConverter.class})
public class AttachmentDTOConverter
implements DTOConverter<CPAttachmentFileEntry, Attachment> {
    @Reference
    private CommerceMediaResolver _commerceMediaResolver;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CPAttachmentFileEntryService _cpAttachmentFileEntryService;
    @Reference
    private JSONFactory _jsonFactory;

    public String getContentType() {
        return Attachment.class.getSimpleName();
    }

    public Attachment toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPAttachmentFileEntry cpAttachmentFileEntry = this._cpAttachmentFileEntryService.getCPAttachmentFileEntry(((Long)dtoConverterContext.getId()).longValue());
        Company company = this._companyLocalService.getCompany(cpAttachmentFileEntry.getCompanyId());
        final String portalURL = company.getPortalURL(0L);
        return new Attachment(){
            {
                this.customFields = CustomFieldsUtil.toCustomFields(dtoConverterContext.isAcceptAllLanguages(), CPAttachmentFileEntry.class.getName(), cpAttachmentFileEntry.getCPAttachmentFileEntryId(), cpAttachmentFileEntry.getCompanyId(), dtoConverterContext.getLocale());
                this.displayDate = cpAttachmentFileEntry.getDisplayDate();
                this.expirationDate = cpAttachmentFileEntry.getExpirationDate();
                this.externalReferenceCode = cpAttachmentFileEntry.getExternalReferenceCode();
                this.id = cpAttachmentFileEntry.getCPAttachmentFileEntryId();
                this.options = AttachmentDTOConverter.this._getAttachmentOptions(cpAttachmentFileEntry);
                this.priority = cpAttachmentFileEntry.getPriority();
                this.src = portalURL + AttachmentDTOConverter.this._commerceMediaResolver.getDownloadUrl(cpAttachmentFileEntry.getCPAttachmentFileEntryId());
                this.title = LanguageUtils.getLanguageIdMap((Map)cpAttachmentFileEntry.getTitleMap());
                this.type = cpAttachmentFileEntry.getType();
            }
        };
    }

    private Map<String, String> _getAttachmentOptions(CPAttachmentFileEntry cpAttachmentFileEntry) throws JSONException {
        String json = cpAttachmentFileEntry.getJson();
        if (Validator.isNull((String)json)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> options = new HashMap<String, String>();
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (Object element : jsonArray) {
            JSONObject jsonObject = (JSONObject)element;
            if (!jsonObject.has("key")) continue;
            options.put(jsonObject.getString("key"), jsonObject.getString("value"));
        }
        return options;
    }
}

