/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.headless.commerce.admin.catalog.internal.util.v1_0;

import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.commerce.pricing.model.CommercePricingClassCPDefinitionRel;
import com.liferay.commerce.pricing.service.CommercePricingClassCPDefinitionRelService;
import com.liferay.commerce.product.exception.NoSuchCProductException;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductGroupProduct;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Validator;

/**
 * @author Riccardo Alberti
 */
public class ProductGroupProductUtil {

	public static CommercePricingClassCPDefinitionRel
			addCommercePricingClassCPDefinitionRel(
				CProductLocalService cProductLocalService,
				CommercePricingClassCPDefinitionRelService
					commercePricingClassCPDefinitionRelService,
				ProductGroupProduct productGroupProduct,
				CommercePricingClass commercePricingClass,
				ServiceContextHelper serviceContextHelper)
		throws PortalException {

		ServiceContext serviceContext =
			serviceContextHelper.getServiceContext();

		CProduct cProduct;

		if (Validator.isNull(
				productGroupProduct.getProductExternalReferenceCode())) {

			cProduct = cProductLocalService.getCProduct(
				productGroupProduct.getProductId());
		}
		else {
			cProduct = cProductLocalService.fetchCProductByReferenceCode(
				serviceContext.getCompanyId(),
				productGroupProduct.getProductExternalReferenceCode());

			if (cProduct == null) {
				throw new NoSuchCProductException(
					"Unable to find Product with externalReferenceCode: " +
						productGroupProduct.getProductExternalReferenceCode());
			}
		}

		return commercePricingClassCPDefinitionRelService.
			addCommercePricingClassCPDefinitionRel(
				commercePricingClass.getCommercePricingClassId(),
				cProduct.getPublishedCPDefinitionId(), serviceContext);
	}

}