/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.asset.kernel.exception.NoSuchCategoryException;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryService;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Category;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.internal.helper.v1_0.CategoryHelper;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseCategoryResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.CategoryResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.List;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/category.properties"}, scope=ServiceScope.PROTOTYPE, service={CategoryResource.class, NestedFieldSupport.class})
public class CategoryResourceImpl
extends BaseCategoryResourceImpl
implements NestedFieldSupport {
    @Reference
    private AssetCategoryService _assetCategoryService;
    @Reference
    private CategoryHelper _categoryHelper;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Page<Category> getProductByExternalReferenceCodeCategoriesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with externalReferenceCode: " + externalReferenceCode);
        }
        List assetCategories = this._assetCategoryService.getCategories(this._classNameLocalService.getClassNameId(cpDefinition.getModelClass()), cpDefinition.getCPDefinitionId(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._assetCategoryService.getCategoriesCount(this._classNameLocalService.getClassNameId(cpDefinition.getModelClass()), cpDefinition.getCPDefinitionId());
        return Page.of(this._categoryHelper.toProductCategories(assetCategories, this.contextAcceptLanguage.getPreferredLocale()), (Pagination)pagination, (long)totalItems);
    }

    @Override
    @NestedField(parentClass=Product.class, value="categories")
    public Page<Category> getProductIdCategoriesPage(@NestedFieldId(value="productId") Long id, Pagination pagination) throws Exception {
        return this._categoryHelper.getCategoriesPage(id, this.contextAcceptLanguage.getPreferredLocale(), pagination);
    }

    @Override
    public Response patchProductByExternalReferenceCodeCategory(String externalReferenceCode, Category[] categories) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with externalReferenceCode: " + externalReferenceCode);
        }
        this._updateProductCategories(cpDefinition, categories);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchProductIdCategory(Long id, Category[] categories) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        this._updateProductCategories(cpDefinition, categories);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    private void _updateProductCategories(CPDefinition cpDefinition, Category[] categories) throws PortalException {
        long[] assetCategoryIds = new long[]{};
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId());
        for (Category category : categories) {
            AssetCategory assetCategory = this._assetCategoryService.fetchCategory(category.getId().longValue());
            if (assetCategory == null) {
                throw new NoSuchCategoryException("Unable to find Category with ID: " + category.getId());
            }
            assetCategoryIds = ArrayUtil.append((long[])assetCategoryIds, (long)assetCategory.getCategoryId());
        }
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        this._cpDefinitionService.updateCPDefinitionCategorization(cpDefinition.getCPDefinitionId(), serviceContext);
    }
}

