/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPOptionCategoryException;
import com.liferay.commerce.product.model.CPOptionCategory;
import com.liferay.commerce.product.service.CPOptionCategoryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.OptionCategory;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseOptionCategoryResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.OptionCategoryResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/option-category.properties"}, scope=ServiceScope.PROTOTYPE, service={OptionCategoryResource.class})
public class OptionCategoryResourceImpl
extends BaseOptionCategoryResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(OptionCategoryResourceImpl.class);
    @Reference
    private CPOptionCategoryService _cpOptionCategoryService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Context
    private User _user;

    @Override
    public Response deleteOptionCategory(Long id) throws Exception {
        this._cpOptionCategoryService.deleteCPOptionCategory(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Page<OptionCategory> getOptionCategoriesPage(Pagination pagination) throws Exception {
        BaseModelSearchResult cpOptionCategoryBaseModelSearchResult = this._cpOptionCategoryService.searchCPOptionCategories(this._user.getCompanyId(), null, pagination.getStartPosition(), pagination.getEndPosition(), null);
        return Page.of(this._toOptionCategories(cpOptionCategoryBaseModelSearchResult.getBaseModels()), (Pagination)pagination, (long)cpOptionCategoryBaseModelSearchResult.getLength());
    }

    @Override
    public OptionCategory getOptionCategory(Long id) throws Exception {
        DTOConverter optionCategoryDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPOptionCategory.class.getName());
        return (OptionCategory)optionCategoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), (Object)id));
    }

    @Override
    public Response patchOptionCategory(Long id, OptionCategory optionCategory) throws Exception {
        this._updateOptionCategory(id, optionCategory);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public OptionCategory postOptionCategory(OptionCategory optionCategory) throws Exception {
        return this._upsertOptionCategory(optionCategory);
    }

    private List<OptionCategory> _toOptionCategories(List<CPOptionCategory> cpOptionCategories) throws Exception {
        ArrayList<OptionCategory> optionCategories = new ArrayList<OptionCategory>();
        DTOConverter optionCategoryDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPOptionCategory.class.getName());
        for (CPOptionCategory cpOptionCategory : cpOptionCategories) {
            optionCategories.add((OptionCategory)optionCategoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpOptionCategory.getCPOptionCategoryId())));
        }
        return optionCategories;
    }

    private CPOptionCategory _updateOptionCategory(Long id, OptionCategory optionCategory) throws PortalException {
        CPOptionCategory cpOptionCategory = this._cpOptionCategoryService.getCPOptionCategory(id.longValue());
        return this._cpOptionCategoryService.updateCPOptionCategory(cpOptionCategory.getCPOptionCategoryId(), LanguageUtils.getLocalizedMap((Map)optionCategory.getTitle()), LanguageUtils.getLocalizedMap((Map)optionCategory.getDescription()), GetterUtil.get((Object)optionCategory.getPriority(), (double)cpOptionCategory.getPriority()), optionCategory.getKey());
    }

    private OptionCategory _upsertOptionCategory(OptionCategory optionCategory) throws Exception {
        DTOConverter optionCategoryDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPOptionCategory.class.getName());
        try {
            CPOptionCategory cpOptionCategory = this._updateOptionCategory(optionCategory.getId(), optionCategory);
            return (OptionCategory)optionCategoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpOptionCategory.getCPOptionCategoryId()));
        }
        catch (NoSuchCPOptionCategoryException nscpoce) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to find optionCategory with ID: " + optionCategory.getId()));
            }
            ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(this._user);
            CPOptionCategory cpOptionCategory = this._cpOptionCategoryService.addCPOptionCategory(LanguageUtils.getLocalizedMap((Map)optionCategory.getTitle()), LanguageUtils.getLocalizedMap((Map)optionCategory.getDescription()), GetterUtil.get((Object)optionCategory.getPriority(), (double)0.0), optionCategory.getKey(), serviceContext);
            return (OptionCategory)optionCategoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpOptionCategory.getCPOptionCategoryId()));
        }
    }
}

