/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductShippingConfiguration;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.math.BigDecimal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=ProductShippingConfiguration"}, service={DTOConverter.class, ProductShippingConfigurationDTOConverter.class})
public class ProductShippingConfigurationDTOConverter
implements DTOConverter<CPDefinition, ProductShippingConfiguration> {
    @Reference
    private CPDefinitionService _cpDefinitionService;

    public String getContentType() {
        return ProductShippingConfiguration.class.getSimpleName();
    }

    public ProductShippingConfiguration toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinition cpDefinition = this._cpDefinitionService.getCPDefinition(((Long)dtoConverterContext.getId()).longValue());
        return new ProductShippingConfiguration(){
            {
                this.depth = BigDecimal.valueOf(cpDefinition.getDepth());
                this.freeShipping = cpDefinition.isFreeShipping();
                this.height = BigDecimal.valueOf(cpDefinition.getHeight());
                this.shippable = cpDefinition.isShippable();
                this.shippingExtraPrice = BigDecimal.valueOf(cpDefinition.getShippingExtraPrice());
                this.shippingSeparately = cpDefinition.isShipSeparately();
                this.weight = BigDecimal.valueOf(cpDefinition.getWeight());
                this.width = BigDecimal.valueOf(cpDefinition.getWidth());
            }
        };
    }
}

