/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionSpecificationOptionValue;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CPAttachmentFileEntryService;
import com.liferay.commerce.product.service.CPDefinitionLinkService;
import com.liferay.commerce.product.service.CPDefinitionOptionRelService;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelService;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CPDefinitionSpecificationOptionValueService;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.product.service.CPOptionService;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.commerce.service.CPDefinitionInventoryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Attachment;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Category;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductOption;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductOptionValue;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductShippingConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductSpecification;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductSubscriptionConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductTaxConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.RelatedProduct;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.ExpandoUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.AttachmentUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductConfigurationUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductOptionUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductOptionValueUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductShippingConfigurationUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductSpecificationUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductSubscriptionConfigurationUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductTaxConfigurationUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.RelatedProductUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.SkuUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.upload.UniqueFileNameProvider;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/product.properties"}, scope=ServiceScope.PROTOTYPE, service={ProductResource.class})
public class ProductResourceImpl
extends BaseProductResourceImpl {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;
    @Reference
    private CPAttachmentFileEntryService _cpAttachmentFileEntryService;
    @Reference
    private CPDefinitionInventoryService _cpDefinitionInventoryService;
    @Reference
    private CPDefinitionLinkService _cpDefinitionLinkService;
    @Reference
    private CPDefinitionOptionRelService _cpDefinitionOptionRelService;
    @Reference
    private CPDefinitionOptionValueRelService _cpDefinitionOptionValueRelService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPDefinitionSpecificationOptionValueService _cpDefinitionSpecificationOptionValueService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private CPOptionService _cpOptionService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private UniqueFileNameProvider _uniqueFileNameProvider;
    @Context
    private User _user;

    @Override
    public Response deleteProduct(Long id) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        this._cpDefinitionService.deleteCPDefinition(cpDefinition.getCPDefinitionId());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response deleteProductByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with externalReferenceCode: " + externalReferenceCode);
        }
        this._cpDefinitionService.deleteCPDefinition(cpDefinition.getCPDefinitionId());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Product getProduct(Long id) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        DTOConverter productDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPDefinition.class.getName());
        return (Product)productDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinition.getCPDefinitionId()));
    }

    @Override
    public Product getProductByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with externalReferenceCode: " + externalReferenceCode);
        }
        DTOConverter productDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPDefinition.class.getName());
        return (Product)productDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinition.getCPDefinitionId()));
    }

    @Override
    public Page<Product> getProductsPage(Pagination pagination) throws Exception {
        BaseModelSearchResult cpDefinitionBaseModelSearchResult = this._cpDefinitionService.searchCPDefinitions(this.contextCompany.getCompanyId(), null, null, null, pagination.getStartPosition(), pagination.getEndPosition(), null);
        return Page.of(this._toProducts(cpDefinitionBaseModelSearchResult.getBaseModels()), (Pagination)pagination, (long)cpDefinitionBaseModelSearchResult.getLength());
    }

    @Override
    public Response patchProduct(Long id, Product product) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        this._updateProduct(cpDefinition, product);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response patchProductByExternalReferenceCode(String externalReferenceCode, Product product) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with externalReferenceCode: " + externalReferenceCode);
        }
        this._updateProduct(cpDefinition, product);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Product postProduct(Product product) throws Exception {
        CPDefinition cpDefinition = this._upsertProduct(product);
        DTOConverter productDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPDefinition.class.getName());
        return (Product)productDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinition.getCPDefinitionId()));
    }

    private List<Product> _toProducts(List<CPDefinition> cpDefinitions) throws Exception {
        ArrayList<Product> products = new ArrayList<Product>();
        DTOConverter productDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPDefinition.class.getName());
        for (CPDefinition cpDefinition : cpDefinitions) {
            products.add((Product)productDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinition.getCPDefinitionId())));
        }
        return products;
    }

    private CPDefinition _updateNestedResources(Product product, CPDefinition cpDefinition, ServiceContext serviceContext) throws Exception {
        Category[] categories;
        Sku[] skus;
        RelatedProduct[] relatedProducts;
        ProductOption[] productOptions;
        ProductSpecification[] productSpecifications;
        Attachment[] images;
        Attachment[] attachments;
        ProductTaxConfiguration productTaxConfiguration;
        ProductSubscriptionConfiguration productSubscriptionConfiguration;
        ProductShippingConfiguration productShippingConfiguration;
        ProductConfiguration productConfiguration = product.getConfiguration();
        if (productConfiguration != null) {
            ProductConfigurationUtil.updateCPDefinitionInventory(this._cpDefinitionInventoryService, productConfiguration, cpDefinition.getCPDefinitionId(), serviceContext);
        }
        if ((productShippingConfiguration = product.getShippingConfiguration()) != null) {
            cpDefinition = ProductShippingConfigurationUtil.updateCPDefinitionShippingInfo(this._cpDefinitionService, productShippingConfiguration, cpDefinition, serviceContext);
        }
        if ((productSubscriptionConfiguration = product.getSubscriptionConfiguration()) != null) {
            cpDefinition = ProductSubscriptionConfigurationUtil.updateCPDefinitionSubscriptionInfo(this._cpDefinitionService, productSubscriptionConfiguration, cpDefinition, serviceContext);
        }
        if ((productTaxConfiguration = product.getTaxConfiguration()) != null) {
            cpDefinition = ProductTaxConfigurationUtil.updateCPDefinitionTaxCategoryInfo(this._cpDefinitionService, productTaxConfiguration, cpDefinition);
        }
        if ((attachments = product.getAttachments()) != null) {
            for (Attachment attachment : attachments) {
                AttachmentUtil.upsertCPAttachmentFileEntry(this._cpAttachmentFileEntryService, this._uniqueFileNameProvider, attachment, this._classNameLocalService.getClassNameId(cpDefinition.getModelClassName()), cpDefinition.getCPDefinitionId(), 1, serviceContext);
            }
        }
        if ((images = product.getImages()) != null) {
            for (Attachment image : images) {
                AttachmentUtil.upsertCPAttachmentFileEntry(this._cpAttachmentFileEntryService, this._uniqueFileNameProvider, image, this._classNameLocalService.getClassNameId(cpDefinition.getModelClassName()), cpDefinition.getCPDefinitionId(), 0, serviceContext);
            }
        }
        if ((productSpecifications = product.getProductSpecifications()) != null) {
            for (ProductSpecification productSpecification : productSpecifications) {
                CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this._cpDefinitionSpecificationOptionValueService.fetchCPDefinitionSpecificationOptionValue(productSpecification.getId().longValue());
                if (cpDefinitionSpecificationOptionValue == null) {
                    ProductSpecificationUtil.addCPDefinitionSpecificationOptionValue(this._cpDefinitionSpecificationOptionValueService, cpDefinition.getCPDefinitionId(), productSpecification, serviceContext);
                    continue;
                }
                ProductSpecificationUtil.updateCPDefinitionSpecificationOptionValue(this._cpDefinitionSpecificationOptionValueService, cpDefinitionSpecificationOptionValue, productSpecification, serviceContext);
            }
        }
        if ((productOptions = product.getOptions()) != null) {
            for (ProductOption productOption : productOptions) {
                CPDefinitionOptionRel cpDefinitionOptionRel = ProductOptionUtil.upsertCPDefinitionOptionRel(this._cpDefinitionOptionRelService, this._cpOptionService, productOption, cpDefinition.getCPDefinitionId(), serviceContext);
                ProductOptionValue[] productOptionValues = productOption.getValues();
                if (productOptionValues == null) continue;
                for (ProductOptionValue productOptionValue : productOptionValues) {
                    ProductOptionValueUtil.upsertCPDefinitionOptionValueRel(this._cpDefinitionOptionValueRelService, productOptionValue, cpDefinitionOptionRel.getCPDefinitionOptionRelId(), serviceContext);
                }
            }
        }
        if ((relatedProducts = product.getRelatedProducts()) != null) {
            for (RelatedProduct relatedProduct : relatedProducts) {
                RelatedProductUtil.upsertCPDefinitionLink(this._cpDefinitionLinkService, relatedProduct, cpDefinition.getCPDefinitionId(), this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId()));
            }
        }
        if ((skus = product.getSkus()) != null) {
            for (Sku sku : skus) {
                SkuUtil.upsertCPInstance(this._cpInstanceService, sku, cpDefinition, serviceContext);
            }
        }
        if ((categories = product.getCategories()) != null) {
            // empty if block
        }
        return cpDefinition;
    }

    private CPDefinition _updateProduct(CPDefinition cpDefinition, Product product) throws Exception {
        long siteId = cpDefinition.getGroupId();
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(siteId);
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        DateConfig displayDateConfig = new DateConfig(displayCalendar);
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        expirationCalendar.add(2, 1);
        DateConfig expirationDateConfig = new DateConfig(expirationCalendar);
        boolean neverExpire = Boolean.TRUE;
        cpDefinition = this._cpDefinitionService.updateCPDefinition(cpDefinition.getCPDefinitionId(), LanguageUtils.getLocalizedMap((Map)product.getName()), LanguageUtils.getLocalizedMap((Map)product.getShortDescription()), LanguageUtils.getLocalizedMap((Map)product.getDescription()), cpDefinition.getUrlTitleMap(), cpDefinition.getMetaTitleMap(), cpDefinition.getMetaDescriptionMap(), cpDefinition.getMetaKeywordsMap(), cpDefinition.isIgnoreSKUCombinations(), cpDefinition.getDDMStructureKey(), true, displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), neverExpire, serviceContext);
        Map expando = product.getExpando();
        if (!expando.isEmpty()) {
            ExpandoUtil.updateExpando(serviceContext.getCompanyId(), CPDefinition.class, cpDefinition.getPrimaryKey(), expando);
        }
        cpDefinition = this._updateNestedResources(product, cpDefinition, serviceContext);
        return cpDefinition;
    }

    private CPDefinition _upsertProduct(Product product) throws Exception {
        Map expando;
        boolean neverExpire = Boolean.TRUE;
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        DateConfig displayDateConfig = new DateConfig(displayCalendar);
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        expirationCalendar.add(2, 1);
        DateConfig expirationDateConfig = new DateConfig(expirationCalendar);
        ProductShippingConfiguration shippingConfiguration = product.getShippingConfiguration();
        ProductSubscriptionConfiguration subscriptionConfiguration = product.getSubscriptionConfiguration();
        ProductTaxConfiguration taxConfiguration = product.getTaxConfiguration();
        CommerceCatalog commerceCatalog = this._commerceCatalogLocalService.getCommerceCatalog(product.getCatalogId().longValue());
        CPDefinition cpDefinition = this._cpDefinitionService.upsertCPDefinition(commerceCatalog.getGroupId(), this._user.getUserId(), LanguageUtils.getLocalizedMap((Map)product.getName()), LanguageUtils.getLocalizedMap((Map)product.getShortDescription()), LanguageUtils.getLocalizedMap((Map)product.getDescription()), null, LanguageUtils.getLocalizedMap((Map)product.getName()), null, null, product.getProductType(), true, GetterUtil.getBoolean((Object)shippingConfiguration.getShippable(), (boolean)true), GetterUtil.getBoolean((Object)shippingConfiguration.getFreeShipping(), (boolean)true), GetterUtil.getBoolean((Object)shippingConfiguration.getShippingSeparately(), (boolean)true), GetterUtil.getDouble((Object)shippingConfiguration.getShippingExtraPrice(), (double)0.0), GetterUtil.getDouble((Object)shippingConfiguration.getWidth(), (double)0.0), GetterUtil.getDouble((Object)shippingConfiguration.getHeight(), (double)0.0), GetterUtil.getDouble((Object)shippingConfiguration.getDepth(), (double)0.0), GetterUtil.getDouble((Object)shippingConfiguration.getWeight(), (double)0.0), GetterUtil.getLong((Object)taxConfiguration.getId(), (long)0L), ProductUtil.isTaxExempt(null, taxConfiguration), false, null, true, displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), neverExpire, product.getDefaultSku(), GetterUtil.getBoolean((Object)subscriptionConfiguration.getEnable(), (boolean)false), GetterUtil.getInteger((Object)subscriptionConfiguration.getLength(), (int)0), GetterUtil.getString((String)subscriptionConfiguration.getSubscriptionTypeAsString()), null, GetterUtil.getLong((Object)subscriptionConfiguration.getNumberOfLength(), (long)0L), product.getExternalReferenceCode(), serviceContext);
        if (!product.getActive().booleanValue()) {
            HashMap workflowContext = new HashMap();
            this._cpDefinitionService.updateStatus(this._user.getUserId(), cpDefinition.getCPDefinitionId(), 5, serviceContext, workflowContext);
        }
        if (!(expando = product.getExpando()).isEmpty()) {
            ExpandoUtil.updateExpando(serviceContext.getCompanyId(), CPDefinition.class, cpDefinition.getPrimaryKey(), expando);
        }
        this._updateNestedResources(product, cpDefinition, serviceContext);
        return cpDefinition;
    }
}

