/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseProductResourceImpl
implements ProductResource {
    @Context
    protected AcceptLanguage contextAcceptLanguage;
    @Context
    protected Company contextCompany;
    @Context
    protected UriInfo contextUriInfo;

    @Consumes(value={"application/json", "application/xml"})
    @POST
    @Path(value="/product/")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Product")})
    public Product postProduct(Product product) throws Exception {
        return new Product();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Path(value="/products/")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Product")})
    public Page<Product> getProductsPage(@Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Path(value="/products/by-externalReferenceCode/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Product")})
    public Response deleteProductByExternalReferenceCode(@NotNull @Parameter(hidden=true) @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Path(value="/products/by-externalReferenceCode/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Product")})
    public Product getProductByExternalReferenceCode(@NotNull @Parameter(hidden=true) @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new Product();
    }

    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Path(value="/products/by-externalReferenceCode/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Product")})
    public Response patchProductByExternalReferenceCode(@NotNull @Parameter(hidden=true) @PathParam(value="externalReferenceCode") String externalReferenceCode, Product product) throws Exception {
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="id")})
    @Path(value="/products/{id}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Product")})
    public Response deleteProduct(@NotNull @Parameter(hidden=true) @PathParam(value="id") Long id) throws Exception {
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="id")})
    @Path(value="/products/{id}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Product")})
    public Product getProduct(@NotNull @Parameter(hidden=true) @PathParam(value="id") Long id) throws Exception {
        return new Product();
    }

    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="id")})
    @Path(value="/products/{id}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Product")})
    public Response patchProduct(@NotNull @Parameter(hidden=true) @PathParam(value="id") Long id, Product product) throws Exception {
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    protected void preparePatch(Product product, Product existingProduct) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

