/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPAttachmentFileEntryException;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPAttachmentFileEntryService;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Attachment;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseAttachmentResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.DateConfigUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.AttachmentUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.AttachmentResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.upload.UniqueFileNameProvider;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/attachment.properties"}, scope=ServiceScope.PROTOTYPE, service={AttachmentResource.class})
public class AttachmentResourceImpl
extends BaseAttachmentResourceImpl {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CPAttachmentFileEntryService _cpAttachmentFileEntryService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private UniqueFileNameProvider _uniqueFileNameProvider;

    @Override
    public Response deleteAttachment(Long id) throws Exception {
        this._cpAttachmentFileEntryService.deleteCPAttachmentFileEntry(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response deleteAttachmentByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPAttachmentFileEntry cpAttachmentFileEntry = this._cpAttachmentFileEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpAttachmentFileEntry == null) {
            throw new NoSuchCPAttachmentFileEntryException("Unable to find Attachment with externalReferenceCode: " + externalReferenceCode);
        }
        this._cpAttachmentFileEntryService.deleteCPAttachmentFileEntry(cpAttachmentFileEntry.getCPAttachmentFileEntryId());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Attachment getAttachment(Long id) throws Exception {
        DTOConverter attachmentDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPAttachmentFileEntry.class.getName());
        return (Attachment)attachmentDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), GetterUtil.getLong((Object)id)));
    }

    @Override
    public Attachment getAttachmentByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPAttachmentFileEntry cpAttachmentFileEntry = this._cpAttachmentFileEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpAttachmentFileEntry == null) {
            throw new NoSuchCPAttachmentFileEntryException("Unable to find Attachment with externalReferenceCode: " + externalReferenceCode);
        }
        DTOConverter attachmentDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPAttachmentFileEntry.class.getName());
        return (Attachment)attachmentDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpAttachmentFileEntry.getCPAttachmentFileEntryId()));
    }

    @Override
    public Page<Attachment> getProductByExternalReferenceCodeexternalReferenceCodeAttachmentsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with externalReferenceCode: " + externalReferenceCode);
        }
        return this._getAttachmentPage(cpDefinition, 1, pagination);
    }

    @Override
    public Page<Attachment> getProductByExternalReferenceCodeImagesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with externalReferenceCode: " + externalReferenceCode);
        }
        return this._getAttachmentPage(cpDefinition, 0, pagination);
    }

    @Override
    public Page<Attachment> getProductIdAttachmentsPage(Long id, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        return this._getAttachmentPage(cpDefinition, 1, pagination);
    }

    @Override
    public Page<Attachment> getProductIdImagesPage(Long id, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        return this._getAttachmentPage(cpDefinition, 0, pagination);
    }

    @Override
    public Response patchAttachment(Long id, Attachment attachment) throws Exception {
        CPAttachmentFileEntry cpAttachmentFileEntry = this._cpAttachmentFileEntryService.getCPAttachmentFileEntry(id.longValue());
        this._updateAttachment(cpAttachmentFileEntry, attachment);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response patchAttachmentByExternalReferenceCode(String externalReferenceCode, Attachment attachment) throws Exception {
        CPAttachmentFileEntry cpAttachmentFileEntry = this._cpAttachmentFileEntryService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpAttachmentFileEntry == null) {
            throw new NoSuchCPAttachmentFileEntryException("Unable to find Attachment with externalReferenceCode: " + externalReferenceCode);
        }
        this._updateAttachment(cpAttachmentFileEntry, attachment);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Attachment postProductByExternalReferenceCodeAttachment(String externalReferenceCode, Attachment attachment) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with externalReferenceCode: " + externalReferenceCode);
        }
        return this._upsertProductAttachment(cpDefinition, attachment);
    }

    @Override
    public Attachment postProductByExternalReferenceCodeImage(String externalReferenceCode, Attachment attachment) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with externalReferenceCode: " + externalReferenceCode);
        }
        return this._upsertProductImage(cpDefinition, attachment);
    }

    @Override
    public Attachment postProductIdAttachment(Long id, Attachment attachment) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        return this._upsertProductAttachment(cpDefinition, attachment);
    }

    @Override
    public Attachment postProductIdImage(Long id, Attachment attachment) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        return this._upsertProductImage(cpDefinition, attachment);
    }

    private Page<Attachment> _getAttachmentPage(CPDefinition cpDefinition, int type, Pagination pagination) throws Exception {
        List cpAttachmentFileEntries = this._cpAttachmentFileEntryService.getCPAttachmentFileEntries(this._classNameLocalService.getClassNameId(cpDefinition.getModelClass()), cpDefinition.getCPDefinitionId(), type, 0, pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._cpAttachmentFileEntryService.getCPAttachmentFileEntriesCount(this._classNameLocalService.getClassNameId(cpDefinition.getModelClass()), cpDefinition.getCPDefinitionId(), type, 0);
        return Page.of(this._toAttachments(cpAttachmentFileEntries), (Pagination)pagination, (long)totalItems);
    }

    private List<Attachment> _toAttachments(List<CPAttachmentFileEntry> cpAttachmentFileEntries) throws Exception {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        DTOConverter attachmentDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPAttachmentFileEntry.class.getName());
        for (CPAttachmentFileEntry cpAttachmentFileEntry : cpAttachmentFileEntries) {
            attachments.add((Attachment)attachmentDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpAttachmentFileEntry.getCPAttachmentFileEntryId())));
        }
        return attachments;
    }

    private Attachment _updateAttachment(CPAttachmentFileEntry cpAttachmentFileEntry, Attachment attachment) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(cpAttachmentFileEntry.getGroupId());
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        if (attachment.getDisplayDate() != null) {
            displayCalendar = DateConfigUtil.convertDateToCalendar(attachment.getDisplayDate());
        }
        DateConfig displayDateConfig = new DateConfig(displayCalendar);
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        expirationCalendar.add(2, 1);
        if (attachment.getExpirationDate() != null) {
            expirationCalendar = DateConfigUtil.convertDateToCalendar(attachment.getExpirationDate());
        }
        DateConfig expirationDateConfig = new DateConfig(expirationCalendar);
        FileEntry fileEntry = AttachmentUtil.addFileEntry(attachment, serviceContext.getScopeGroupId(), serviceContext.getUserId(), this._uniqueFileNameProvider);
        if (fileEntry == null) {
            fileEntry = cpAttachmentFileEntry.getFileEntry();
        }
        cpAttachmentFileEntry = this._cpAttachmentFileEntryService.updateCPAttachmentFileEntry(cpAttachmentFileEntry.getCPAttachmentFileEntryId(), fileEntry.getFileEntryId(), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.get((Object)attachment.getNeverExpire(), (cpAttachmentFileEntry.getExpirationDate() == null ? 1 : 0) != 0), AttachmentUtil.getTitleMap(cpAttachmentFileEntry, attachment), GetterUtil.get((Object)attachment.getOptions(), (String)cpAttachmentFileEntry.getJson()), GetterUtil.get((Object)attachment.getPriority(), (double)cpAttachmentFileEntry.getPriority()), attachment.getType().intValue(), serviceContext);
        DTOConverter attachmentDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPAttachmentFileEntry.class.getName());
        return (Attachment)attachmentDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpAttachmentFileEntry.getCPAttachmentFileEntryId()));
    }

    private Attachment _upsertAttachment(CPDefinition cpDefinition, int type, Attachment attachment) throws Exception {
        CPAttachmentFileEntry cpAttachmentFileEntry = AttachmentUtil.upsertCPAttachmentFileEntry(this._cpAttachmentFileEntryService, this._uniqueFileNameProvider, attachment, this._classNameLocalService.getClassNameId(cpDefinition.getModelClassName()), cpDefinition.getCPDefinitionId(), type, this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId()));
        DTOConverter attachmentDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPAttachmentFileEntry.class.getName());
        return (Attachment)attachmentDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpAttachmentFileEntry.getCPAttachmentFileEntryId()));
    }

    private Attachment _upsertProductAttachment(CPDefinition cpDefinition, Attachment attachment) throws Exception {
        return this._upsertAttachment(cpDefinition, 1, attachment);
    }

    private Attachment _upsertProductImage(CPDefinition cpDefinition, Attachment attachment) throws Exception {
        return this._upsertAttachment(cpDefinition, 0, attachment);
    }
}

