/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.util.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionLinkException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionLink;
import com.liferay.commerce.product.service.CPDefinitionLinkService;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.RelatedProduct;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;

public class RelatedProductUtil {
    private static final Log _log = LogFactoryUtil.getLog(RelatedProductUtil.class);

    public static CPDefinitionLink upsertCPDefinitionLink(CPDefinitionLinkService cpDefinitionLinkService, CPDefinitionService cpDefinitionService, RelatedProduct relatedProduct, long cpDefinitionId, ServiceContext serviceContext) throws PortalException {
        try {
            CPDefinitionLink cpDefinitionLink = cpDefinitionLinkService.getCPDefinitionLink(relatedProduct.getId().longValue());
            return cpDefinitionLinkService.updateCPDefinitionLink(relatedProduct.getId().longValue(), GetterUtil.get((Object)relatedProduct.getPriority(), (double)cpDefinitionLink.getPriority()), serviceContext);
        }
        catch (NoSuchCPDefinitionLinkException nscpdle) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to find relatedProduct with ID: " + relatedProduct.getId()));
            }
            CPDefinition cpDefinition = null;
            if (Validator.isNotNull((String)relatedProduct.getProductExternalReferenceCode())) {
                cpDefinition = cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(serviceContext.getCompanyId(), relatedProduct.getProductExternalReferenceCode());
                if (cpDefinition == null) {
                    throw new NoSuchCPDefinitionException("Unable to find Product with externalReferenceCode: " + relatedProduct.getProductExternalReferenceCode());
                }
            } else {
                cpDefinition = cpDefinitionService.fetchCPDefinitionByCProductId(relatedProduct.getProductId().longValue());
                if (cpDefinition == null) {
                    throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + relatedProduct.getProductId());
                }
            }
            return cpDefinitionLinkService.addCPDefinitionLink(cpDefinitionId, cpDefinition.getCProductId(), GetterUtil.get((Object)relatedProduct.getPriority(), (double)0.0), relatedProduct.getType(), serviceContext);
        }
    }
}

