/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.service.CPDefinitionOptionRelService;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CPOptionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductOption;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductOptionResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductOptionUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductOptionResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/product-option.properties"}, scope=ServiceScope.PROTOTYPE, service={ProductOptionResource.class})
public class ProductOptionResourceImpl
extends BaseProductOptionResourceImpl {
    @Reference
    private CPDefinitionOptionRelService _cpDefinitionOptionRelService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPOptionService _cpOptionService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteProductOption(Long id) throws Exception {
        CPDefinitionOptionRel cpDefinitionOptionRel = this._cpDefinitionOptionRelService.getCPDefinitionOptionRel(id.longValue());
        this._cpDefinitionOptionRelService.deleteCPDefinitionOptionRel(cpDefinitionOptionRel.getCPDefinitionOptionRelId());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Page<ProductOption> getProductByExternalReferenceCodeProductOptionsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with externalReferenceCode: " + externalReferenceCode);
        }
        List cpDefinitionOptionRels = this._cpDefinitionOptionRelService.getCPDefinitionOptionRels(cpDefinition.getCPDefinitionId(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._cpDefinitionOptionRelService.getCPDefinitionOptionRelsCount(cpDefinition.getCPDefinitionId());
        return Page.of(this._toProductOptions(cpDefinitionOptionRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Page<ProductOption> getProductIdProductOptionsPage(Long id, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        List cpDefinitionOptionRels = this._cpDefinitionOptionRelService.getCPDefinitionOptionRels(cpDefinition.getCPDefinitionId(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._cpDefinitionOptionRelService.getCPDefinitionOptionRelsCount(cpDefinition.getCPDefinitionId());
        return Page.of(this._toProductOptions(cpDefinitionOptionRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public ProductOption getProductOption(Long id) throws Exception {
        DTOConverter productOptionDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPDefinitionOptionRel.class.getName());
        return (ProductOption)productOptionDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), (Object)id));
    }

    @Override
    public Response patchProductOption(Long id, ProductOption productOption) throws Exception {
        this._updateProductOption(id, productOption);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Page<ProductOption> postProductByExternalReferenceCodeProductOptionsPage(String externalReferenceCode, ProductOption[] productOptions) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with externalReferenceCode: " + externalReferenceCode);
        }
        return Page.of(this._upsertProductOptions(cpDefinition, productOptions));
    }

    @Override
    public Page<ProductOption> postProductIdProductOptionsPage(Long id, ProductOption[] productOptions) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        return Page.of(this._upsertProductOptions(cpDefinition, productOptions));
    }

    private List<ProductOption> _toProductOptions(List<CPDefinitionOptionRel> cpDefinitionOptionRels) throws Exception {
        ArrayList<ProductOption> productOptions = new ArrayList<ProductOption>();
        DTOConverter productOptionDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPDefinitionOptionRel.class.getName());
        for (CPDefinitionOptionRel cpDefinitionOptionRel : cpDefinitionOptionRels) {
            productOptions.add((ProductOption)productOptionDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinitionOptionRel.getCPDefinitionOptionRelId())));
        }
        return productOptions;
    }

    private ProductOption _updateProductOption(long id, ProductOption productOption) throws Exception {
        CPDefinitionOptionRel cpDefinitionOptionRel = this._cpDefinitionOptionRelService.getCPDefinitionOptionRel(id);
        ProductOption.FieldType fieldType = productOption.getFieldType();
        cpDefinitionOptionRel = this._cpDefinitionOptionRelService.updateCPDefinitionOptionRel(cpDefinitionOptionRel.getCPDefinitionOptionRelId(), productOption.getOptionId().longValue(), LanguageUtils.getLocalizedMap((Map)productOption.getName()), LanguageUtils.getLocalizedMap((Map)productOption.getDescription()), fieldType.getValue(), GetterUtil.get((Object)productOption.getPriority(), (double)cpDefinitionOptionRel.getPriority()), GetterUtil.get((Object)productOption.getFacetable(), (boolean)cpDefinitionOptionRel.isFacetable()), GetterUtil.get((Object)productOption.getRequired(), (boolean)cpDefinitionOptionRel.isRequired()), GetterUtil.get((Object)productOption.getSkuContributor(), (boolean)cpDefinitionOptionRel.isSkuContributor()), this._serviceContextHelper.getServiceContext(cpDefinitionOptionRel.getGroupId()));
        DTOConverter productOptionDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPDefinitionOptionRel.class.getName());
        return (ProductOption)productOptionDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinitionOptionRel.getCPDefinitionOptionRelId()));
    }

    private List<ProductOption> _upsertProductOptions(CPDefinition cpDefinition, ProductOption[] productOptions) throws Exception {
        for (ProductOption productOption : productOptions) {
            ProductOptionUtil.upsertCPDefinitionOptionRel(this._cpDefinitionOptionRelService, this._cpOptionService, productOption, cpDefinition.getCPDefinitionId(), this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId()));
        }
        ArrayList<ProductOption> productOptionList = new ArrayList<ProductOption>();
        cpDefinition = this._cpDefinitionService.getCPDefinition(cpDefinition.getCPDefinitionId());
        DTOConverter productOptionDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPDefinitionOptionRel.class.getName());
        for (CPDefinitionOptionRel cpDefinitionOptionRel : cpDefinition.getCPDefinitionOptionRels()) {
            productOptionList.add((ProductOption)productOptionDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinitionOptionRel.getCPDefinitionOptionRelId())));
        }
        return productOptionList;
    }
}

