/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPInstanceOptionValueRel;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.product.util.CPInstanceHelper;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Sku;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.product.model.CPInstance"}, service={DTOConverter.class, SkuDTOConverter.class})
public class SkuDTOConverter
implements DTOConverter<CPInstance, Sku> {
    @Reference
    private CPInstanceHelper _cpInstanceHelper;
    @Reference
    private CPInstanceService _cpInstanceService;

    public String getContentType() {
        return Sku.class.getSimpleName();
    }

    public Sku toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CPInstance cpInstance = this._cpInstanceService.getCPInstance(((Long)dtoConverterContext.getId()).longValue());
        return new Sku(){
            {
                this.cost = cpInstance.getCost();
                this.depth = cpInstance.getDepth();
                this.displayDate = cpInstance.getDisplayDate();
                this.expirationDate = cpInstance.getExpirationDate();
                this.externalReferenceCode = cpInstance.getExternalReferenceCode();
                this.gtin = cpInstance.getGtin();
                this.height = cpInstance.getHeight();
                this.id = cpInstance.getCPInstanceId();
                this.manufacturerPartNumber = cpInstance.getManufacturerPartNumber();
                this.options = SkuDTOConverter.this._getOptions(cpInstance);
                this.price = cpInstance.getPrice();
                this.promoPrice = cpInstance.getPromoPrice();
                this.published = cpInstance.isPublished();
                this.purchasable = cpInstance.isPurchasable();
                this.sku = cpInstance.getSku();
                this.unspsc = cpInstance.getUnspsc();
                this.weight = cpInstance.getWeight();
                this.width = cpInstance.getWidth();
            }
        };
    }

    private Map<String, String> _getOptions(CPInstance cpInstance) {
        HashMap<String, String> options = new HashMap<String, String>();
        List cpInstanceOptionValueRels = this._cpInstanceHelper.getCPInstanceCPInstanceOptionValueRels(cpInstance.getCPDefinitionId());
        for (CPInstanceOptionValueRel cpInstanceOptionValueRel : cpInstanceOptionValueRels) {
            options.put(String.valueOf(cpInstanceOptionValueRel.getCPDefinitionOptionRelId()), String.valueOf(cpInstanceOptionValueRel.getCPDefinitionOptionValueRelId()));
        }
        return options;
    }
}

