/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.service.CPDefinitionInventoryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfiguration;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductConfigurationResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductConfigurationUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductConfigurationResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/product-configuration.properties"}, scope=ServiceScope.PROTOTYPE, service={ProductConfigurationResource.class})
public class ProductConfigurationResourceImpl
extends BaseProductConfigurationResourceImpl {
    @Reference
    private CPDefinitionInventoryService _cpDefinitionInventoryService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public ProductConfiguration getProductByExternalReferenceCodeConfiguration(String externalReferenceCode) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with externalReferenceCode: " + externalReferenceCode);
        }
        DTOConverter productConfigurationDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPDefinitionInventory.class.getName());
        return (ProductConfiguration)productConfigurationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinition.getCPDefinitionId()));
    }

    @Override
    public ProductConfiguration getProductIdConfiguration(Long id) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        DTOConverter productConfigurationDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPDefinitionInventory.class.getName());
        return (ProductConfiguration)productConfigurationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinition.getCPDefinitionId()));
    }

    @Override
    public Response patchProductByExternalReferenceCodeConfiguration(String externalReferenceCode, ProductConfiguration productConfiguration) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with externalReferenceCode: " + externalReferenceCode);
        }
        ProductConfigurationUtil.updateCPDefinitionInventory(this._cpDefinitionInventoryService, productConfiguration, cpDefinition.getCPDefinitionId(), this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId()));
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response patchProductIdConfiguration(Long id, ProductConfiguration productConfiguration) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        ProductConfigurationUtil.updateCPDefinitionInventory(this._cpDefinitionInventoryService, productConfiguration, cpDefinition.getCPDefinitionId(), this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId()));
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }
}

