/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCatalogException;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CommerceCatalogService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Catalog;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseCatalogResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.CatalogResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/catalog.properties"}, scope=ServiceScope.PROTOTYPE, service={CatalogResource.class})
public class CatalogResourceImpl
extends BaseCatalogResourceImpl {
    @Reference
    private CommerceCatalogService _commerceCatalogService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteCatalog(Long id) throws Exception {
        this._commerceCatalogService.deleteCommerceCatalog(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response deleteCatalogByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceCatalog == null) {
            throw new NoSuchCatalogException("Unable to find Catalog with externalReferenceCode: " + externalReferenceCode);
        }
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Catalog getCatalog(Long id) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.fetchCommerceCatalog(id.longValue());
        if (commerceCatalog == null) {
            throw new NoSuchCatalogException("Unable to find Catalog with ID: " + id);
        }
        DTOConverter catalogDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceCatalog.class.getName());
        return (Catalog)catalogDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), commerceCatalog.getCommerceCatalogId()));
    }

    @Override
    public Catalog getCatalogByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceCatalog == null) {
            throw new NoSuchCatalogException("Unable to find Catalog with externalReferenceCode: " + externalReferenceCode);
        }
        DTOConverter catalogDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceCatalog.class.getName());
        return (Catalog)catalogDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), commerceCatalog.getCommerceCatalogId()));
    }

    @Override
    public Page<Catalog> getCatalogsPage(Pagination pagination) throws Exception {
        return super.getCatalogsPage(pagination);
    }

    @Override
    public Response patchCatalog(Long id, Catalog catalog) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.getCommerceCatalog(id.longValue());
        this._commerceCatalogService.updateCommerceCatalog(commerceCatalog.getCommerceCatalogId(), catalog.getName(), GetterUtil.get((String)catalog.getCurrencyCode(), (String)commerceCatalog.getCommerceCurrencyCode()), GetterUtil.get((String)catalog.getDefaultLanguageId(), (String)commerceCatalog.getCatalogDefaultLanguageId()));
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchCatalogByExternalReferenceCode(String externalReferenceCode, Catalog catalog) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (commerceCatalog == null) {
            throw new NoSuchCatalogException("Unable to find Catalog with externalReferenceCode: " + externalReferenceCode);
        }
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Catalog postCatalog(Catalog catalog) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), catalog.getExternalReferenceCode());
        commerceCatalog = commerceCatalog == null ? this._commerceCatalogService.addCommerceCatalog(commerceCatalog.getName(), catalog.getCurrencyCode(), catalog.getDefaultLanguageId(), catalog.getExternalReferenceCode(), this._serviceContextHelper.getServiceContext()) : this._commerceCatalogService.updateCommerceCatalog(commerceCatalog.getCommerceCatalogId(), commerceCatalog.getName(), GetterUtil.get((String)catalog.getCurrencyCode(), (String)commerceCatalog.getCommerceCurrencyCode()), GetterUtil.get((String)catalog.getDefaultLanguageId(), (String)commerceCatalog.getCatalogDefaultLanguageId()));
        DTOConverter catalogDTOConverter = this._dtoConverterRegistry.getDTOConverter(CommerceCatalog.class.getName());
        return (Catalog)catalogDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), commerceCatalog.getCommerceCatalogId()));
    }
}

