/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionLink;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.CPDefinitionLinkService;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.RelatedProduct;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.product.model.CPDefinitionLink"}, service={DTOConverter.class, RelatedProductDTOConverter.class})
public class RelatedProductDTOConverter
implements DTOConverter {
    @Reference
    private CPDefinitionLinkService _cpDefinitionLinkService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;

    public String getContentType() {
        return RelatedProduct.class.getSimpleName();
    }

    public RelatedProduct toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinitionLink cpDefinitionLink = this._cpDefinitionLinkService.getCPDefinitionLink(dtoConverterContext.getResourcePrimKey());
        CProduct cProduct = cpDefinitionLink.getCProduct();
        final CPDefinition cpDefinition = this._cpDefinitionService.getCPDefinition(cProduct.getPublishedCPDefinitionId());
        final DTOConverter productDTOConverter = this._dtoConverterRegistry.getDTOConverter(cpDefinition.getModelClassName());
        return new RelatedProduct(){
            {
                this.id = cpDefinitionLink.getCPDefinitionLinkId();
                this.priority = cpDefinitionLink.getPriority();
                this.product = (Product)productDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(dtoConverterContext.getLocale(), cpDefinition.getCPDefinitionId()));
                this.productId = cpDefinitionLink.getCPDefinitionId();
                this.type = cpDefinitionLink.getType();
            }
        };
    }
}

