/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPOptionException;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.model.CPOptionValue;
import com.liferay.commerce.product.service.CPOptionService;
import com.liferay.commerce.product.service.CPOptionValueService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Option;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.OptionValue;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.OptionValueDTOConverter;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseOptionValueResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.OptionValueResource;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/option-value.properties"}, scope=ServiceScope.PROTOTYPE, service={OptionValueResource.class})
public class OptionValueResourceImpl
extends BaseOptionValueResourceImpl {
    @Reference
    private CPOptionService _cpOptionService;
    @Reference
    private CPOptionValueService _cpOptionValueService;
    @Reference
    private OptionValueDTOConverter _optionValueDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Page<OptionValue> getOptionByExternalReferenceCodeOptionValuesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CPOption cpOption = this._cpOptionService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpOption == null) {
            throw new NoSuchCPOptionException("Unable to find Option with externalReferenceCode: " + externalReferenceCode);
        }
        List cpOptionValues = this._cpOptionValueService.getCPOptionValues(cpOption.getCPOptionId(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._cpOptionValueService.getCPOptionValuesCount(cpOption.getCPOptionId());
        return Page.of(this._toOptionValues(cpOptionValues), (Pagination)pagination, (long)totalItems);
    }

    @Override
    @NestedField(parentClass=Option.class, value="values")
    public Page<OptionValue> getOptionIdOptionValuesPage(Long id, Pagination pagination) throws Exception {
        CPOption cpOption = this._cpOptionService.getCPOption(id.longValue());
        List cpOptionValues = this._cpOptionValueService.getCPOptionValues(cpOption.getCPOptionId(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._cpOptionValueService.getCPOptionValuesCount(cpOption.getCPOptionId());
        return Page.of(this._toOptionValues(cpOptionValues), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public OptionValue postOptionByExternalReferenceCodeOptionValue(String externalReferenceCode, OptionValue optionValue) throws Exception {
        CPOption cpOption = this._cpOptionService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpOption == null) {
            throw new NoSuchCPOptionException("Unable to find Option with externalReferenceCode: " + externalReferenceCode);
        }
        return this._upsertOptionValue(cpOption, optionValue);
    }

    @Override
    public OptionValue postOptionIdOptionValue(Long id, OptionValue optionValue) throws Exception {
        return this._upsertOptionValue(this._cpOptionService.getCPOption(id.longValue()), optionValue);
    }

    private List<OptionValue> _toOptionValues(List<CPOptionValue> cpOptionValues) throws Exception {
        ArrayList<OptionValue> productOptionValues = new ArrayList<OptionValue>();
        for (CPOptionValue cpOptionValue : cpOptionValues) {
            productOptionValues.add(this._optionValueDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpOptionValue.getCPOptionValueId(), this.contextAcceptLanguage.getPreferredLocale())));
        }
        return productOptionValues;
    }

    private OptionValue _upsertOptionValue(CPOption cpOption, OptionValue optionValue) throws Exception {
        CPOptionValue cpOptionValue = this._cpOptionValueService.upsertCPOptionValue(cpOption.getCPOptionId(), LanguageUtils.getLocalizedMap((Map)optionValue.getName()), GetterUtil.get((Object)optionValue.getPriority(), (double)0.0), optionValue.getKey(), optionValue.getExternalReferenceCode(), this._serviceContextHelper.getServiceContext());
        return this._optionValueDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpOptionValue.getCPOptionValueId(), this.contextAcceptLanguage.getPreferredLocale()));
    }
}

