/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetTagModel;
import com.liferay.asset.kernel.service.AssetTagService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.product.model.CPDefinition"}, service={DTOConverter.class, ProductDTOConverter.class})
public class ProductDTOConverter
implements DTOConverter<CPDefinition, Product> {
    @Reference
    private AssetTagService _assetTagService;
    @Reference
    private CPDefinitionService _cpDefinitionService;

    public String getContentType() {
        return Product.class.getSimpleName();
    }

    public Product toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinition cpDefinition = this._cpDefinitionService.getCPDefinition(((Long)dtoConverterContext.getId()).longValue());
        final CProduct cProduct = cpDefinition.getCProduct();
        final ExpandoBridge expandoBridge = cpDefinition.getExpandoBridge();
        return new Product(){
            {
                this.active = !cpDefinition.isInactive();
                this.catalogId = ProductDTOConverter.this._getCommerceCatalogId(cpDefinition);
                this.createDate = cpDefinition.getCreateDate();
                this.description = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getDescriptionMap());
                this.displayDate = cpDefinition.getDisplayDate();
                this.expando = expandoBridge.getAttributes();
                this.expirationDate = cpDefinition.getExpirationDate();
                this.externalReferenceCode = cProduct.getExternalReferenceCode();
                this.id = cpDefinition.getCPDefinitionId();
                this.metaDescription = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaDescriptionMap());
                this.metaKeyword = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaKeywordsMap());
                this.metaTitle = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaTitleMap());
                this.modifiedDate = cpDefinition.getModifiedDate();
                this.name = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getNameMap());
                this.productId = cProduct.getCProductId();
                this.productType = cpDefinition.getProductTypeName();
                this.shortDescription = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getShortDescriptionMap());
                this.tags = ProductDTOConverter.this._getTags(cpDefinition);
            }
        };
    }

    private long _getCommerceCatalogId(CPDefinition cpDefinition) {
        CommerceCatalog commerceCatalog = cpDefinition.getCommerceCatalog();
        if (commerceCatalog == null) {
            return 0L;
        }
        return commerceCatalog.getCommerceCatalogId();
    }

    private String[] _getTags(CPDefinition cpDefinition) {
        List assetEntryAssetTags = this._assetTagService.getTags(cpDefinition.getModelClassName(), cpDefinition.getCPDefinitionId());
        Stream stream = assetEntryAssetTags.stream();
        return (String[])stream.map(AssetTagModel::getName).toArray(String[]::new);
    }
}

