/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.exception.NoSuchCPInstanceException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.admin.catalog.internal.helper.v1_0.SkuHelper;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseSkuResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.DateConfigUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.SkuUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.SkuResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/sku.properties"}, scope=ServiceScope.PROTOTYPE, service={SkuResource.class})
public class SkuResourceImpl
extends BaseSkuResourceImpl {
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private SkuHelper _skuHelper;

    @Override
    public Response deleteSku(Long id) throws Exception {
        this._cpInstanceService.deleteCPInstance(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response deleteSkuByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPInstance cpInstance = this._cpInstanceService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpInstance == null) {
            throw new NoSuchCPInstanceException("Unable to find Sku with externalReferenceCode: " + externalReferenceCode);
        }
        this._cpInstanceService.deleteCPInstance(cpInstance.getCPInstanceId());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Page<Sku> getProductByExternalReferenceCodeSkusPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with externalReferenceCode: " + externalReferenceCode);
        }
        List cpInstances = this._cpInstanceService.getCPDefinitionInstances(cpDefinition.getCPDefinitionId(), 0, pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._cpInstanceService.getCPDefinitionInstancesCount(cpDefinition.getCPDefinitionId(), 0);
        return Page.of(this._skuHelper.toSKUs(cpInstances, this.contextAcceptLanguage.getPreferredLocale()), (Pagination)pagination, (long)totalItems);
    }

    @Override
    @NestedField(parentClass=Product.class, value="skus")
    public Page<Sku> getProductIdSkusPage(@NestedFieldId(value="productId") @NotNull Long id, Pagination pagination) throws Exception {
        return this._skuHelper.getSkusPage(id, this.contextAcceptLanguage.getPreferredLocale(), pagination);
    }

    @Override
    public Sku getSku(Long id) throws Exception {
        DTOConverter skuDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPInstance.class.getName());
        return (Sku)skuDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), GetterUtil.getLong((Object)id)));
    }

    @Override
    public Sku getSkuByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPInstance cpInstance = this._cpInstanceService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpInstance == null) {
            throw new NoSuchCPInstanceException("Unable to find Sku with externalReferenceCode: " + externalReferenceCode);
        }
        DTOConverter skuDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPInstance.class.getName());
        return (Sku)skuDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpInstance.getCPInstanceId()));
    }

    @Override
    public Response patchSku(Long id, Sku sku) throws Exception {
        this._updateSKU(this._cpInstanceService.getCPInstance(id.longValue()), sku);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchSkuByExternalReferenceCode(String externalReferenceCode, Sku sku) throws Exception {
        CPInstance cpInstance = this._cpInstanceService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpInstance == null) {
            throw new NoSuchCPInstanceException("Unable to find Sku with externalReferenceCode: " + externalReferenceCode);
        }
        this._updateSKU(cpInstance, sku);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Sku postProductByExternalReferenceCodeSku(String externalReferenceCode, Sku sku) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with externalReferenceCode: " + externalReferenceCode);
        }
        return this._upsertSKU(cpDefinition, sku);
    }

    @Override
    public Sku postProductIdSku(@NotNull Long id, Sku sku) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        return this._upsertSKU(cpDefinition, sku);
    }

    private Sku _updateSKU(CPInstance cpInstance, Sku sku) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(cpInstance.getGroupId());
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        if (sku.getDisplayDate() != null) {
            displayCalendar = DateConfigUtil.convertDateToCalendar(sku.getDisplayDate());
        }
        DateConfig displayDateConfig = new DateConfig(displayCalendar);
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        expirationCalendar.add(2, 1);
        if (sku.getExpirationDate() != null) {
            expirationCalendar = DateConfigUtil.convertDateToCalendar(sku.getExpirationDate());
        }
        DateConfig expirationDateConfig = new DateConfig(expirationCalendar);
        cpInstance = this._cpInstanceService.updateCPInstance(cpInstance.getCPInstanceId(), sku.getSku(), sku.getGtin(), sku.getManufacturerPartNumber(), GetterUtil.get((Object)sku.getPurchasable(), (boolean)cpInstance.isPurchasable()), GetterUtil.get((Object)sku.getPublished(), (boolean)cpInstance.isPublished()), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.get((Object)sku.getNeverExpire(), (cpInstance.getExpirationDate() == null ? 1 : 0) != 0), serviceContext);
        DTOConverter skuDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPInstance.class.getName());
        return (Sku)skuDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpInstance.getCPInstanceId()));
    }

    private Sku _upsertSKU(CPDefinition cpDefinition, Sku sku) throws Exception {
        CPInstance cpInstance = SkuUtil.upsertCPInstance(this._cpInstanceService, sku, cpDefinition, this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId()));
        DTOConverter skuDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPInstance.class.getName());
        return (Sku)skuDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpInstance.getCPInstanceId()));
    }
}

